/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.filter;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class CsrfFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CsrfFilter.class);
    private String csrfWhiteDomains = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.csrf.white.domains");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String referer = req.getHeader("referer");
        if (StrUtil.isNotBlank((CharSequence)referer)) {
            URL refererURL = new URL(referer);
            String refererHost = refererURL.getHost();
            log.info("refererHost:{}", (Object)refererHost);
            if (refererHost.equals("localhost") || refererHost.equals("127.0.0.1")) {
                filterChain.doFilter(request, response);
                return;
            }
            String refererHostAndPort = this.getHostAndPort(refererURL);
            String serviceURL = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address");
            String requestHostAndPort = this.getHostAndPort(new URL(serviceURL));
            if (requestHostAndPort.equalsIgnoreCase(refererHostAndPort)) {
                filterChain.doFilter(request, response);
            } else {
                if (this.isCsrfWhiteDomains(refererHostAndPort)) {
                    filterChain.doFilter(request, response);
                    return;
                }
                this.forwardToController(request, response);
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private String getHostAndPort(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        return port == -1 ? host : host + ":" + port;
    }

    private void forwardToController(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        request.setAttribute("filter.error", (Object)new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWHXCLQVVIOqBy_2b60332d", (String)"csrf\u8de8\u7ad9\u70b9\u4f2a\u9020\u8bf7\u6c42\u5df2\u7ecf\u88ab\u62e6\u622a")));
        request.getRequestDispatcher("/error/exception-throw").forward(request, response);
    }

    public void destroy() {
    }

    private boolean isCsrfWhiteDomains(String refererHostAndPort) {
        if (StrUtil.isNotBlank((CharSequence)this.csrfWhiteDomains)) {
            String[] var2;
            for (String csrfWhiteDomain : var2 = this.csrfWhiteDomains.split(",")) {
                if (StrUtil.isBlank((CharSequence)csrfWhiteDomain) || !refererHostAndPort.toLowerCase().contains(csrfWhiteDomain.toLowerCase())) continue;
                log.info("\u7b26\u5408\u8de8\u7ad9\u70b9\u8bf7\u6c42\u3010\u57df\u540d\u3011\u767d\u540d\u5355\uff1arefererHost = {}", (Object)refererHostAndPort);
                return true;
            }
        }
        return false;
    }
}

