/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.rpc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.material.api.dto.PurchaseMaterialCodeDTO;
import com.els.modules.material.api.dto.TreeMaterialCodeNodeDTO;
import com.els.modules.material.api.service.PurchaseMaterialCodeRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseMaterialCodeBeanServiceImpl
implements PurchaseMaterialCodeRpcService {
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public PurchaseMaterialCodeDTO selectById(String id) {
        PurchaseMaterialCode code = (PurchaseMaterialCode)this.purchaseMaterialCodeService.getById((Serializable)((Object)id));
        return (PurchaseMaterialCodeDTO)SysUtil.copyProperties((Object)code, PurchaseMaterialCodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> selectMaterialCateListByCodeList(List<String> cateCodeList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List purchaseMaterialCodeList = this.purchaseMaterialCodeService.listByCodeList(cateCodeList, loginUser.getElsAccount());
        return SysUtil.copyProperties((List)purchaseMaterialCodeList, PurchaseMaterialCodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> listByIds(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseMaterialCodeList = this.purchaseMaterialCodeService.listByIds(idList);
        return SysUtil.copyProperties((List)purchaseMaterialCodeList, PurchaseMaterialCodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> listByElsAccount() {
        LoginUser loginUser = SysUtil.getLoginUser();
        List purchaseMaterialCodeList = this.purchaseMaterialCodeService.listByElsAccount(loginUser.getElsAccount());
        return SysUtil.copyProperties((List)purchaseMaterialCodeList, PurchaseMaterialCodeDTO.class);
    }

    public boolean updateBatchById(List<PurchaseMaterialCodeDTO> list) {
        ArrayList purchaseMaterialCodes = SysUtil.copyProperties(list, PurchaseMaterialCode.class);
        return this.purchaseMaterialCodeService.updateBatchById((Collection)purchaseMaterialCodes);
    }

    public List<TreeMaterialCodeNodeDTO> list(List<String> idList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!CollectionUtils.isEmpty(idList)) {
            queryWrapper.in((Object)"id", idList);
        }
        List materialCodeTree = this.purchaseMaterialCodeService.getMaterialCodeTree(queryWrapper);
        return SysUtil.copyProperties((List)materialCodeTree, TreeMaterialCodeNodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> listMaterialCodeBySale(List<String> codes, String elsAccount) {
        List list = this.purchaseMaterialCodeService.listMaterialCodeBySale(codes, elsAccount);
        return SysUtil.copyProperties((List)list, PurchaseMaterialCodeDTO.class);
    }
}

