/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.api.service.impl;

import com.els.common.api.service.JobRpcService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.rpc.service.InvokeAccountRpcService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="orgSyncJobServiceImpl")
public class OrganizationSyncJobServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(OrganizationSyncJobServiceImpl.class);
    @Resource
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;
    @Resource
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    public static final String ORGANIZATION_SYNC_JOB_KEY = "ifs_organization_sync_job";
    private final long EXPIRE_TIME = 300000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String parameter) {
        ElsSubAccountDTO subAccountDTO = this.invokeAccountRpcService.getAccount("3107679", "1001");
        LoginUser loginUser = new LoginUser();
        BeanUtils.copyProperties((Object)subAccountDTO, (Object)loginUser);
        LoginUserContext.setUser((LoginUser)loginUser);
        TenantContext.setTenant((String)"3107679");
        try {
            if (!this.redisUtil.tryGetDistributedLock(ORGANIZATION_SYNC_JOB_KEY, "3107679", 300000L)) {
                throw new Exception("IFS\u83b7\u53d6\u516c\u53f8\u3001\u57df\u4fe1\u606f\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d");
            }
            log.info(" IFS\u83b7\u53d6\u516c\u53f8\u3001\u57df\u4fe1\u606f\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1 organizationSyncJobServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4\uff1a" + DateUtils.getTimestamp() + parameter);
            if (StringUtils.isBlank((CharSequence)parameter)) {
                log.error("parameter must not be null.");
                return;
            }
            this.purchaseOrganizationInfoService.getCompanyAndDomainByIFS();
            log.info(" IFS\u83b7\u53d6\u516c\u53f8\u3001\u57df\u4fe1\u606f\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1 organizationSyncJobServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.redisUtil.releaseDistributedLock(ORGANIZATION_SYNC_JOB_KEY, "3107679");
            TenantContext.clear();
            LoginUserContext.clear();
        }
    }
}

