/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.sql.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.context.TokenContext;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.third.sql.dto.MaterialFromOracleDto;
import com.els.modules.third.sql.util.OracleSqlUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.rpc.service.ManualTransactionManagementService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialFromCQGTOracleDbImpl.class);
    @Autowired
    private PurchaseMaterialHeadService materialHeadService;
    @Autowired
    private PurchaseMaterialItemService materialItemService;
    @Autowired
    private TemplateRpcService templateRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    @Resource
    private ManualTransactionManagementService manualTransactionManagementService;
    @Autowired
    private RedisUtil redisUtil;
    String key = "GetMaterialFromCQGTOracleDbImpl:";

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_MTL_SYSTEM_ITEMS";
        obj.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetMaterialFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray itemList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        String elsAccount = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        String token = this.getToken();
        this.key = this.key + elsAccount;
        if (null != this.redisUtil.get(this.key)) {
            return interfaceResult;
        }
        this.redisUtil.set(this.key, (Object)this.key);
        try {
            Executor executor = (Executor)SpringContextUtils.getBean((String)"asyncExecutor", Executor.class);
            executor.execute(() -> {
                try {
                    TenantContext.setTenant((String)elsAccount);
                    LoginUserContext.setUser((LoginUser)loginUser);
                    TokenContext.setToken((String)token);
                    try {
                        this.manualTransactionManagementService.begin();
                    }
                    catch (Exception e) {
                        log.error("GetMaterialFromCQGTOracleDbImpl\u5f00\u542f\u4e8b\u52a1\u5931\u8d25", (Throwable)e);
                    }
                    this.saveInfo(itemList, elsAccount);
                    try {
                        this.manualTransactionManagementService.commit();
                    }
                    catch (Exception e) {
                        log.error("GetMaterialFromCQGTOracleDbImpl\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.error("\u5f02\u6b65\u6267\u884c\u7269\u6599\u4e3b\u6570\u636e\u5931\u8d25:", (Throwable)e);
                    try {
                        this.manualTransactionManagementService.rollback();
                    }
                    catch (Exception e1) {
                        log.error("GetMaterialFromCQGTOracleDbImpl\u56de\u6eda\u4e8b\u52a1\u5931\u8d25", (Throwable)e1);
                    }
                }
                finally {
                    TenantContext.clear();
                    LoginUserContext.clear();
                    TokenContext.clear();
                }
            });
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.redisUtil.del(new String[]{this.key});
                throw throwable;
            }
        }
        this.redisUtil.del(new String[]{this.key});
        return interfaceResult;
    }

    private void saveInfo(JSONArray itemList, String elsAccount) {
        ArrayList<PurchaseMaterialHead> insertmaterials = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialHead> updateMaterials = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialItem> insertMaterialItems = new ArrayList<PurchaseMaterialItem>();
        List templateList = this.templateRpcService.getDefaultTemplateByType("material");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f", (Object[])new Object[0]);
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
        Map<String, PurchaseMaterialHead> materialMap = this.getPurchaseMaterial(elsAccount);
        LoginUser loginUser = SysUtil.getLoginUser();
        Map<String, String> factoryMap = this.invokeBaseRpcService.queryTableDictListByFilterSql(TenantContext.getTenant(), "purchase_organization_info", "org_name", "org_code", "org_category_code='factory' and status='1'").stream().collect(Collectors.toMap(DictDTO::getValue, DictDTO::getText));
        Map<String, String> codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, PurchaseMaterialCode::getCateName, (newVal, oldVal) -> oldVal));
        Map<String, List<Object>> groupItem = itemList.stream().collect(Collectors.groupingBy(item -> JSON.parseObject((String)item.toString()).getString("ITEM_CODE")));
        for (Map.Entry<String, List<Object>> entry : groupItem.entrySet()) {
            PurchaseMaterialHead head = null;
            List<Object> value = entry.getValue();
            for (int i = 0; i < value.size(); ++i) {
                JSONObject materialDtoJson = (JSONObject)value.get(i);
                MaterialFromOracleDto materialDto = (MaterialFromOracleDto)JSON.parseObject((String)materialDtoJson.toJSONString(), MaterialFromOracleDto.class);
                String cateCode = materialDto.getCateCode();
                if (i == 0) {
                    if (materialMap.containsKey(materialDto.getMaterialNumber())) {
                        head = this.setPurchaseMaterialHead(false, template, materialMap, headDefaultValue, materialDto, cateCode, codeMap.get(cateCode));
                        this.materialItemService.deleteByMainId(head.getId());
                        updateMaterials.add(head);
                        continue;
                    }
                    head = this.setPurchaseMaterialHead(true, template, materialMap, headDefaultValue, materialDto, cateCode, codeMap.get(cateCode));
                    insertmaterials.add(head);
                }
                PurchaseMaterialItem item2 = new PurchaseMaterialItem();
                item2.setHeadId(head.getId());
                item2.setMaterialNumber(materialDto.getMaterialNumber());
                item2.setFactory(materialDto.getFactoryCode());
                item2.setFactoryName(factoryMap.get(materialDto.getFactoryCode()));
                item2.setItemCount(Integer.valueOf(0));
                item2.setFbk10(materialDto.getSourceId());
                item2.setElsAccount(elsAccount);
                item2.setCreateBy(loginUser.getSubAccount());
                item2.setCreateById(loginUser.getId());
                item2.setCreateTime(new Date());
                item2.setUpdateBy(loginUser.getSubAccount());
                item2.setUpdateById(loginUser.getId());
                insertMaterialItems.add(item2);
            }
        }
        if (CollectionUtil.isNotEmpty(insertmaterials)) {
            this.materialHeadService.saveBatch(insertmaterials, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateMaterials)) {
            this.materialHeadService.updateBatchById(updateMaterials, 2000);
        }
        if (CollectionUtil.isNotEmpty(insertMaterialItems)) {
            this.materialItemService.saveBatch(insertMaterialItems, 2000);
        }
    }

    private Map<String, PurchaseMaterialHead> getPurchaseMaterial(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.eq(PurchaseMaterialHead::getSourceType, (Object)"erp");
        List list = this.materialHeadService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseMaterialHead>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private PurchaseMaterialHead setPurchaseMaterialHead(boolean isSave, TemplateHeadDTO template, Map<String, PurchaseMaterialHead> materialMap, Map<String, String> headDefaultValue, MaterialFromOracleDto materialDto, String cateCode, String cateName) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (isSave) {
            PurchaseMaterialHead materialHead = (PurchaseMaterialHead)JSON.parseObject((String)JSON.toJSONString(headDefaultValue), PurchaseMaterialHead.class);
            materialHead.setId(IdWorker.getIdStr());
            materialHead.setElsAccount(TenantContext.getTenant());
            materialHead.setTemplateNumber(template.getTemplateNumber());
            materialHead.setTemplateName(template.getTemplateName());
            materialHead.setTemplateAccount(template.getElsAccount());
            materialHead.setTemplateVersion(template.getTemplateVersion());
            materialHead.setMaterialNumber(materialDto.getMaterialNumber());
            materialHead.setMaterialName(materialDto.getMaterialName());
            materialHead.setMaterialDesc(materialDto.getMaterialName());
            materialHead.setBaseUnit(materialDto.getBaseUnit());
            materialHead.setPurchaseUnit(materialDto.getBaseUnit());
            materialHead.setRepertoryUnit(materialDto.getBaseUnit());
            materialHead.setUpdateTime(OracleSqlUtil.getUpdateTime((String)materialDto.getUpdateTime()));
            materialHead.setCateCode(cateCode);
            materialHead.setCateName(cateName);
            materialHead.setCateLevelCode("1");
            materialHead.setNeedAudit("0");
            materialHead.setSubmitStatus("0");
            materialHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            materialHead.setSourceType("erp");
            materialHead.setSourceId(materialDto.getSourceId());
            materialHead.setCreateBy(loginUser.getSubAccount());
            materialHead.setCreateById(loginUser.getId());
            materialHead.setCreateTime(new Date());
            materialHead.setUpdateBy(loginUser.getSubAccount());
            materialHead.setUpdateById(loginUser.getId());
            return materialHead;
        }
        PurchaseMaterialHead materialHead = materialMap.get(materialDto.getMaterialNumber());
        materialHead.setMaterialName(materialDto.getMaterialName());
        materialHead.setMaterialDesc(materialDto.getMaterialName());
        materialHead.setCateCode(cateCode);
        materialHead.setCateName(cateName);
        materialHead.setBaseUnit(materialDto.getBaseUnit());
        materialHead.setPurchaseUnit(materialDto.getBaseUnit());
        materialHead.setRepertoryUnit(materialDto.getBaseUnit());
        materialHead.setUpdateTime(OracleSqlUtil.getUpdateTime((String)materialDto.getUpdateTime()));
        materialHead.setUpdateBy(loginUser.getSubAccount());
        materialHead.setUpdateById(loginUser.getId());
        return materialHead;
    }

    private String getToken() {
        String token = SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = SpringContextUtils.getHttpServletRequest().getHeader("token");
        }
        return token;
    }
}

