/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.sql.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.third.sql.util.OracleSqlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetOrganizationFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetOrganizationFromCQGTOracleDbImpl.class);
    @Autowired
    private TemplateRpcService templateRpcService;
    @Autowired
    private BaseRpcService baseRpcService;
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_ORG_MESSAGE";
        obj.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        PurchaseOrganizationInfo info;
        log.info("GetOrganizationFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray ItemList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        String elsAccount = TenantContext.getTenant();
        ArrayList<PurchaseOrganizationInfo> insertAccount = new ArrayList<PurchaseOrganizationInfo>();
        ArrayList<PurchaseOrganizationInfo> updateAccount = new ArrayList<PurchaseOrganizationInfo>();
        List templateList = this.templateRpcService.getDefaultTemplateByType("org");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f", (Object[])new Object[0]);
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        Map<String, String> categoryCodeMap = this.baseRpcService.queryDictItemsByCode("orgCategoryCode", "100000").stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue, (newVal, oldVal) -> oldVal));
        Map<String, PurchaseOrganizationInfo> orgInfoMap = this.getOrganizationInfo(elsAccount);
        for (Object object : ItemList) {
            PurchaseOrganizationInfo organizationInfo;
            JSONObject item = (JSONObject)object;
            String orgCode = item.getString("ORG_CODE");
            String orgName = item.getString("ORG_NAME");
            String orgCategoryCode = item.getString("ORG_CATEGORY");
            String orgNature = item.getString("ORG_NATURE");
            String status = item.getString("STATUS");
            String superBusinessId = item.getString("SUPER_ORG");
            String updateTime = item.getString("UPDATE_TIME");
            if (orgInfoMap.containsKey(orgName)) {
                organizationInfo = orgInfoMap.get(orgName);
                organizationInfo.setOrgCode(orgCode);
                organizationInfo.setOrgName(orgName);
                if (StringUtils.isNotBlank((String)orgCategoryCode) && categoryCodeMap.containsKey(orgCategoryCode)) {
                    organizationInfo.setOrgCategoryCode(categoryCodeMap.get(orgCategoryCode));
                }
                organizationInfo.setOrgNature("\u4e1a\u52a1\u7ec4\u7ec7".equals(orgNature) ? "0" : "1");
                organizationInfo.setStatus("\u6b63\u5e38".equals(status) ? "1" : "2");
                organizationInfo.setSuperBusinessId(superBusinessId);
                organizationInfo.setUpdateTime(OracleSqlUtil.getUpdateTime((String)updateTime));
                updateAccount.add(organizationInfo);
                continue;
            }
            organizationInfo = new PurchaseOrganizationInfo();
            organizationInfo.setId(IdWorker.getIdStr());
            organizationInfo.setElsAccount(elsAccount);
            organizationInfo.setTemplateNumber(template.getTemplateNumber());
            organizationInfo.setTemplateName(template.getTemplateName());
            organizationInfo.setTemplateVersion(template.getTemplateVersion());
            organizationInfo.setTemplateAccount(template.getElsAccount());
            organizationInfo.setOrgCode(orgCode);
            organizationInfo.setOrgName(orgName);
            if (StringUtils.isNotBlank((String)orgCategoryCode) && categoryCodeMap.containsKey(orgCategoryCode)) {
                organizationInfo.setOrgCategoryCode(categoryCodeMap.get(orgCategoryCode));
            }
            organizationInfo.setOrgNature("\u4e1a\u52a1\u7ec4\u7ec7".equals(orgNature) ? "0" : "1");
            organizationInfo.setStatus("\u6b63\u5e38".equals(status) ? "1" : "2");
            organizationInfo.setDataSource("1");
            organizationInfo.setSourceType("third");
            organizationInfo.setSourceSystem("oracle");
            organizationInfo.setSuperBusinessId(superBusinessId);
            organizationInfo.setDeleted(CommonConstant.DEL_FLAG_0);
            if (StringUtils.isNotBlank((String)updateTime)) {
                organizationInfo.setUpdateTime(OracleSqlUtil.getUpdateTime((String)updateTime));
            }
            insertAccount.add(organizationInfo);
            orgInfoMap.put(orgCode, organizationInfo);
        }
        if (CollectionUtil.isNotEmpty(insertAccount)) {
            for (PurchaseOrganizationInfo organizationInfo : insertAccount) {
                if (!StringUtils.isNotBlank((String)organizationInfo.getSuperBusinessId())) continue;
                info = orgInfoMap.get(organizationInfo.getSuperBusinessId());
                organizationInfo.setSuperBusinessId(info.getId());
            }
            this.purchaseOrganizationInfoService.saveBatch(insertAccount, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateAccount)) {
            for (PurchaseOrganizationInfo organizationInfo : updateAccount) {
                if (!StringUtils.isNotBlank((String)organizationInfo.getSuperBusinessId())) continue;
                info = orgInfoMap.get(organizationInfo.getSuperBusinessId());
                organizationInfo.setSuperBusinessId(info.getId());
            }
            this.purchaseOrganizationInfoService.updateBatchById(updateAccount, 2000);
        }
        return interfaceResult;
    }

    private Map<String, PurchaseOrganizationInfo> getOrganizationInfo(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        List list = this.purchaseOrganizationInfoService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseOrganizationInfo>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgName, Function.identity(), (newVal, oldVal) -> oldVal));
    }
}

