/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.jdyxc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.third.base.enums.SourceTypeEnum;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import com.els.modules.third.jdyxc.util.XcApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialCodeFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialCodeFromXcDbImpl.class);
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    private static final String MATERIAL_CODE_LIST = "/jdy/v2/bd/material_group";
    private static final String MATERIAL_CODE_DETAIL = "/jdy/v2/bd/material_group_detail";

    public JSONObject before(JSONObject obj, Object custom) {
        return this.getSendJSON(obj, custom, MATERIAL_CODE_LIST);
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        log.info("GetMaterialCodeFromXcV2DbImpl -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj));
        List resultData = JSON.parseArray((String)JSONArray.toJSONString((Object)this.handlerHeadResultListInfo(obj), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Map.class);
        if (CollUtil.isEmpty((Collection)resultData)) {
            obj.put("message", (Object)"\u6682\u65e0\u7269\u6599\u5206\u7c7b\u6570\u636e\u9700\u8981\u540c\u6b65");
            return obj;
        }
        Map returnMap = resultData.stream().collect(Collectors.toMap(o -> o.get("id").toString(), Function.identity()));
        Set<String> sourceIds = returnMap.keySet();
        JSONArray jsonArray = new JSONArray();
        for (String sourceId : sourceIds) {
            JSONObject jsonObject = XcApiUtil.findInterfaceById((String)elsAccount, (String)"getMaterialClassDetail", (String)sourceId, (String)MATERIAL_CODE_DETAIL);
            jsonArray.add((Object)jsonObject);
        }
        resultData = JSON.parseArray((String)jsonArray.toJSONString(), Map.class);
        resultData = ThirdUtil.getFieldMapping((List)resultData, (String)elsAccount, (String)"getMaterialClass", null);
        Map<String, PurchaseMaterialCode> dbMap = this.getPurchaseMaterialCode(elsAccount, resultData);
        HashMap<String, PurchaseMaterialCode> allMap = new HashMap<String, PurchaseMaterialCode>(dbMap);
        ArrayList<PurchaseMaterialCode> insertList = new ArrayList<PurchaseMaterialCode>();
        ArrayList<PurchaseMaterialCode> updateList = new ArrayList<PurchaseMaterialCode>();
        for (Map data : resultData) {
            PurchaseMaterialCode materialCode = (PurchaseMaterialCode)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseMaterialCode.class);
            allMap.put(materialCode.getSourceId(), materialCode);
            if (dbMap.containsKey(materialCode.getSourceId())) {
                PurchaseMaterialCode purchaseMaterialCode = dbMap.get(materialCode.getSourceId());
                materialCode.setId(purchaseMaterialCode.getId());
                updateList.add(materialCode);
                continue;
            }
            materialCode.setElsAccount(elsAccount);
            materialCode.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
            materialCode.setSourceSystem(ThirdTypeEnum.THIRD_JD_XC.getValue());
            materialCode.setSourceType(SourceTypeEnum.ERP.getDesc());
            insertList.add(materialCode);
        }
        this.setParentCode(insertList, allMap);
        this.setParentCode(updateList, allMap);
        if (!CollUtil.isEmpty(insertList)) {
            this.purchaseMaterialCodeService.saveBatch(insertList, 200);
        }
        if (!CollUtil.isEmpty(updateList)) {
            this.purchaseMaterialCodeService.updateBatchById(updateList, 200);
        }
        this.getPageInfo(obj, custom);
        return obj;
    }

    private void setParentCode(List<PurchaseMaterialCode> list, Map<String, PurchaseMaterialCode> dbMap) {
        for (PurchaseMaterialCode materialCode : list) {
            PurchaseMaterialCode parentCode;
            if (!StringUtils.isNotBlank((CharSequence)materialCode.getUpCateCode()) || (parentCode = dbMap.get(materialCode.getUpCateCode())) == null) continue;
            materialCode.setUpCateCode(parentCode.getCateCode());
            materialCode.setUpCateName(parentCode.getCateName());
        }
    }

    private Map<String, PurchaseMaterialCode> getPurchaseMaterialCode(String elsAccount, List<Map> resultData) {
        List codes = JSON.parseArray((String)JSON.toJSONString(resultData), PurchaseMaterialCode.class);
        List sourceIds = codes.stream().map(PurchaseMaterialCode::getSourceId).collect(Collectors.toList());
        List dbList = this.purchaseMaterialCodeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(PurchaseMaterialCode::getSourceId, sourceIds)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)0));
        if (CollectionUtil.isEmpty((Collection)dbList)) {
            return new HashMap<String, PurchaseMaterialCode>();
        }
        return dbList.stream().collect(Collectors.toMap(PurchaseMaterialCode::getSourceId, Function.identity()));
    }
}

