/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.extend;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialCodeFromLuoShiU8Impl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialCodeFromLuoShiU8Impl.class);
    @Resource
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public JSONObject before(JSONObject jsonObject, Object custom) {
        JSONObject body = new JSONObject();
        body.put("code", (Object)"");
        body.put("name", (Object)"");
        body.put("page_now", (Object)"1");
        body.put("page_size", (Object)"999");
        jsonObject.put("body", (Object)body);
        log.info("SRM\u83b7\u53d6ERP\u7269\u6599\u5206\u7c7b\u63a5\u53e3\uff0c\u5165\u53c2\u4e3a\uff1a" + jsonObject);
        return jsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject after(JSONObject jsonObject, JSONObject paramObj, Object custom) {
        log.info("SRM\u83b7\u53d6ERP\u7269\u6599\u5206\u7c7b\u63a5\u53e3\uff0c\u51fa\u53c2\u4e3a\uff1a" + jsonObject);
        if (!CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) throw new ELSBootException("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5931\u8d25: " + jsonObject.getString("message"));
        JSONObject result = jsonObject.getJSONObject("result");
        String returnStatus = result.getString("status");
        JSONObject data = JSONObject.parseObject((String)result.getString("data"));
        JSONArray codeArray = JSONObject.parseArray((String)data.getString("datas"));
        if ("success".equals(returnStatus)) {
            List<PurchaseMaterialCode> mateCodeList = this.parseTreeData(codeArray, null);
            if (mateCodeList.isEmpty()) return jsonObject;
            this.purchaseMaterialCodeService.saveOrUpdateBatch(mateCodeList, 2000);
            return jsonObject;
        } else {
            String errorMsg = result.getString("errormsg");
            throw new ELSBootException("SRM\u83b7\u53d6ERP\u7269\u6599\u5206\u7c7b\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
        }
    }

    private List<PurchaseMaterialCode> parseTreeData(JSONArray codeArray, PurchaseMaterialCode head) {
        Map codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity()));
        ArrayList<PurchaseMaterialCode> materialCodeList = new ArrayList<PurchaseMaterialCode>();
        for (int i = 0; i < codeArray.size(); ++i) {
            JSONObject codeJson = codeArray.getJSONObject(i);
            String cateCode = codeJson.getString("invclasscode");
            String cateName = codeJson.getString("invclassname");
            String cateLevelCode = codeJson.getString("invclasslev");
            JSONArray children = codeJson.getJSONArray("children");
            PurchaseMaterialCode purchaseMaterialCode = new PurchaseMaterialCode();
            purchaseMaterialCode.setCateCode(cateCode);
            purchaseMaterialCode.setCateName(cateName);
            purchaseMaterialCode.setCateLevelCode(cateLevelCode);
            if (head != null) {
                purchaseMaterialCode.setUpCateCode(head.getCateCode());
                purchaseMaterialCode.setUpCateName(head.getCateName());
            }
            if (codeMap.containsKey(cateCode)) {
                String codeId = ((PurchaseMaterialCode)codeMap.get(cateCode)).getId();
                purchaseMaterialCode.setId(codeId);
            }
            purchaseMaterialCode.setSourceType("erp");
            purchaseMaterialCode.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
            purchaseMaterialCode.setQuotaStrategy("0");
            materialCodeList.add(purchaseMaterialCode);
            if (children == null) continue;
            List<PurchaseMaterialCode> childrenList = this.parseTreeData(children, purchaseMaterialCode);
            materialCodeList.addAll(childrenList);
        }
        return materialCodeList;
    }
}

