/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.DateUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.enumerate.MaterialPurchaseTypeEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GetMaterialFromManXiaoBaoU8Impl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialFromManXiaoBaoU8Impl.class);
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    @Resource
    private PurchaseMaterialUnitService purchaseMaterialUnitService;
    @Resource
    private BaseRpcService baseRpcService;
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    private TemplateRpcService templateRpcService;

    public JSONObject before(JSONObject jsonObject, Object custom) {
        JSONObject body = new JSONObject();
        body.put("startTs", (Object)"2020-08-09");
        body.put("endTs", (Object)DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
        body.put("dr", (Object)"0");
        body.put("unitcode", (Object)"0103");
        JSONObject header = new JSONObject();
        header.put("usercode", (Object)"yxdev");
        header.put("password", (Object)"e10adc3949ba59abbe56e057f20f883e");
        header.put("system", (Object)"yxdev");
        jsonObject.put("header_param", (Object)header);
        jsonObject.put("body", (Object)body);
        log.info("SRM\u83b7\u53d6ERP\u7269\u6599\u4e3b\u6570\u636e\u63a5\u53e3\uff0c\u5165\u53c2\u4e3a\uff1a" + jsonObject);
        return jsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject after(JSONObject jsonObject, JSONObject paramObj, Object custom) {
        log.info("SRM\u83b7\u53d6ERP\u7269\u6599\u4e3b\u6570\u636e\u63a5\u53e3\uff0c\u51fa\u53c2\u4e3a\uff1a" + jsonObject);
        if (!CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) throw new ELSBootException("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5931\u8d25: " + jsonObject.getString("message"));
        JSONObject result = jsonObject.getJSONObject("result");
        String returnStatus = result.getString("status");
        if ("success".equals(returnStatus)) {
            JSONObject data = JSONObject.parseObject((String)result.getString("data"));
            Assert.isTrue((!data.getInteger("retcount").equals(BigDecimal.ZERO) ? 1 : 0) != 0, (String)"\u6682\u65e0\u7269\u6599\u6570\u636e\u9700\u8981\u540c\u6b65");
            JSONArray materialArray = data.getJSONArray("datas");
            List templateList = this.templateRpcService.getDefaultTemplateByType("material");
            Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f");
            TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
            Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
            List dictList = this.baseRpcService.queryDictItemsByCode("unitCode", TenantContext.getTenant());
            Map<String, String> accountMap = this.accountRpcService.getAllByAccount(TenantContext.getTenant()).stream().collect(Collectors.toMap(ElsSubAccountDTO::getSubAccount, BaseDTO::getId));
            Map codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity()));
            Map materialMap = this.purchaseMaterialHeadService.list().stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
            ArrayList<PurchaseMaterialHead> saveList = new ArrayList<PurchaseMaterialHead>();
            ArrayList<PurchaseMaterialHead> updateList = new ArrayList<PurchaseMaterialHead>();
            ArrayList<PurchaseMaterialUnit> unitList = new ArrayList<PurchaseMaterialUnit>();
            for (int i = 0; i < materialArray.size(); ++i) {
                JSONObject materialJson = new JSONObject();
                materialJson.putAll((Map)materialArray.getJSONObject(i).getJSONObject("parentvo").getJSONObject("invbasVo"));
                this.checkRequired(materialJson);
                if ("Z".equals(materialJson.getString("invclcode"))) break;
                String invcode = materialJson.getString("invcode");
                PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)JSON.parseObject((String)JSON.toJSONString((Object)headDefaultValue), PurchaseMaterialHead.class);
                purchaseMaterialHead.setMaterialNumber(invcode);
                purchaseMaterialHead.setMaterialName(materialJson.getString("invname"));
                purchaseMaterialHead.setMaterialDesc(materialJson.getString("invname"));
                purchaseMaterialHead.setMaterialModel(materialJson.getString("invtype"));
                purchaseMaterialHead.setMaterialSpec(materialJson.getString("invspec"));
                purchaseMaterialHead.setCateCode(materialJson.getString("invclcode"));
                purchaseMaterialHead.setCateName(materialJson.getString("invclname"));
                if (materialMap.containsKey("invclcode")) {
                    purchaseMaterialHead.setCateLevelCode(((PurchaseMaterialCode)codeMap.get(materialJson.getString("invclcode"))).getCateLevelCode());
                }
                purchaseMaterialHead.setCreateBy(materialJson.getString("creator"));
                purchaseMaterialHead.setCreateById(accountMap.getOrDefault(materialJson.getString("creator"), ""));
                purchaseMaterialHead.setCreateTime(materialJson.getDate("createtime"));
                purchaseMaterialHead.setUpdateBy(materialJson.getString("modifier"));
                purchaseMaterialHead.setUpdateById(accountMap.getOrDefault(materialJson.getString("modifier"), ""));
                purchaseMaterialHead.setUpdateTime(materialJson.getDate("modifytime"));
                purchaseMaterialHead.setRemark(materialJson.getString("memo"));
                purchaseMaterialHead.setBaseUnit(materialJson.getString("meascode"));
                purchaseMaterialHead.setPurchaseUnit(materialJson.getString("meascode"));
                purchaseMaterialHead.setBrand(materialJson.getString("invpinpai"));
                purchaseMaterialHead.setDeliveryArrange("");
                purchaseMaterialHead.setFbk2(materialJson.getString("invmnecode"));
                purchaseMaterialHead.setFbk3(materialJson.getString("forinvname"));
                purchaseMaterialHead.setFbk4(materialJson.getString("invshortname"));
                purchaseMaterialHead.setElsAccount(TenantContext.getTenant());
                purchaseMaterialHead.setTemplateNumber(template.getTemplateNumber());
                purchaseMaterialHead.setTemplateName(template.getTemplateName());
                purchaseMaterialHead.setTemplateAccount(template.getElsAccount());
                purchaseMaterialHead.setTemplateVersion(template.getTemplateVersion());
                purchaseMaterialHead.setNeedAudit("0");
                purchaseMaterialHead.setSubmitStatus("0");
                purchaseMaterialHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                purchaseMaterialHead.setSourceType("erp");
                purchaseMaterialHead.setCheckQuality("0");
                purchaseMaterialHead.setPurchaseType(MaterialPurchaseTypeEnum.EXTERNAL_PROCUREMENT.getValue());
                purchaseMaterialHead.setDeliveryArrange("4");
                if (materialMap.containsKey(invcode)) {
                    purchaseMaterialHead.setId(((PurchaseMaterialHead)materialMap.get(invcode)).getId());
                    updateList.add(purchaseMaterialHead);
                } else {
                    purchaseMaterialHead.setId(IdWorker.getIdStr());
                    saveList.add(purchaseMaterialHead);
                }
                unitList.addAll(this.generateUnit(purchaseMaterialHead));
            }
            if (!saveList.isEmpty()) {
                this.purchaseMaterialHeadService.saveBatch(saveList, 2000);
            }
            if (!updateList.isEmpty()) {
                this.purchaseMaterialHeadService.updateBatchById(updateList, 2000);
                List headIdList = updateList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                this.purchaseMaterialUnitService.deleteByMainIdList(headIdList);
            }
            if (!CollectionUtil.isNotEmpty(unitList)) return jsonObject;
            this.purchaseMaterialUnitService.saveBatch(unitList, 2000);
            return jsonObject;
        } else {
            String errorMsg = result.getString("errormsg");
            throw new ELSBootException("SRM\u83b7\u53d6ERP\u7269\u6599\u4e3b\u6570\u636e\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
        }
    }

    private void checkRequired(JSONObject materialJson) {
        Assert.notNull((Object)materialJson.get((Object)"invcode"), (String)"\u5b58\u8d27\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)materialJson.get((Object)"invname"), (String)"\u5b58\u8d27\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)materialJson.get((Object)"pk_invcl"), (String)"\u5b58\u8d27\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)materialJson.get((Object)"pk_measdoc"), (String)"\u4e3b\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private List<PurchaseMaterialUnit> generateUnit(PurchaseMaterialHead purchaseMaterialHead) {
        ArrayList<PurchaseMaterialUnit> purchaseMaterialUnitList = new ArrayList<PurchaseMaterialUnit>();
        PurchaseMaterialUnit purchaseUnit = new PurchaseMaterialUnit();
        purchaseUnit.setType("0");
        purchaseUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
        purchaseUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
        purchaseUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
        purchaseUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
        purchaseUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
        purchaseUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
        purchaseUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
        purchaseUnit.setDeleted(purchaseMaterialHead.getDeleted());
        purchaseUnit.setBasicAmount(BigDecimal.ONE);
        purchaseUnit.setObjectAmount(BigDecimal.ONE);
        purchaseUnit.setChangeUnit("=");
        purchaseUnit.setIsDefault("1");
        purchaseUnit.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseUnit.setHeadId(purchaseMaterialHead.getId());
        purchaseMaterialUnitList.add(purchaseUnit);
        PurchaseMaterialUnit repertoryUnit = new PurchaseMaterialUnit();
        repertoryUnit.setType("1");
        repertoryUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
        repertoryUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
        repertoryUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
        repertoryUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
        repertoryUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
        repertoryUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
        repertoryUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
        repertoryUnit.setDeleted(purchaseMaterialHead.getDeleted());
        repertoryUnit.setBasicAmount(BigDecimal.ONE);
        repertoryUnit.setObjectAmount(BigDecimal.ONE);
        repertoryUnit.setChangeUnit("=");
        repertoryUnit.setIsDefault("1");
        repertoryUnit.setDeleted(CommonConstant.DEL_FLAG_0);
        repertoryUnit.setHeadId(purchaseMaterialHead.getId());
        purchaseMaterialUnitList.add(repertoryUnit);
        return purchaseMaterialUnitList;
    }
}

