/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialFromShiWeiJobRpcServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(MaterialFromShiWeiJobRpcServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;

    public void execute(String parameter) {
        String requestId = "GetMaterialShiWeiJob";
        String LOCK_PREFIX = "GetMaterialShiWeiJob_schedule";
        long EXPIRE_TIME = 50000L;
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        if (!this.redisUtil.tryGetDistributedLock(LOCK_PREFIX, requestId, EXPIRE_TIME)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LSiKRcWVxPVBRc_38df5694", (String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        TenantContext.setTenant((String)paramObj.getString("tenant"));
        LoginUser loginUser = SysUtil.getLoginUser();
        if (loginUser == null) {
            loginUser = new LoginUser();
            loginUser.setElsAccount(TenantContext.getTenant());
            loginUser.setSubAccount("1001");
            LoginUserContext.setUser((LoginUser)loginUser);
        }
        log.info("\u83b7\u53d6\u7269\u6599\u4e3b\u6570\u636e\u5b9a\u65f6\u4efb\u52a1 MaterialFromShiWeiJobRpcServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp());
        long startTime = System.currentTimeMillis();
        try {
            log.info("\u7269\u6599\u4e3b\u6570\u636e\u5b9a\u65f6\u4efb\u52a1 MaterialFromShiWeiJobRpcServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
            this.purchaseMaterialHeadService.getDataByErp(null);
            log.info("\u7269\u6599\u4e3b\u6570\u636e\u5b9a\u65f6\u4efb\u52a1 MaterialFromShiWeiJobRpcServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        }
        catch (Exception e) {
            log.error(Thread.currentThread().getName() + " MaterialFromShiWeiJobRpcServiceImpl \u83b7\u53d6\u7269\u6599\u4e3b\u6570\u636e\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_PREFIX, requestId);
        }
        log.info("\u83b7\u53d6\u7269\u6599\u4e3b\u6570\u636e\u5b9a\u65f6\u4efb\u52a1 MaterialFromShiWeiJobRpcServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + "\u603b\u8017\u65f6" + (System.currentTimeMillis() - startTime) + "ms");
    }
}

