/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.sql.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.third.sql.util.OracleSqlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialCodeFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialCodeFromCQGTOracleDbImpl.class);
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_MTL_ITEM_CATEGORIES";
        obj.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        PurchaseMaterialCode info;
        log.info("GetMaterialCodeFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray ItemList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        String elsAccount = TenantContext.getTenant();
        ArrayList<PurchaseMaterialCode> insertAccount = new ArrayList<PurchaseMaterialCode>();
        ArrayList<PurchaseMaterialCode> updateAccount = new ArrayList<PurchaseMaterialCode>();
        Map<String, PurchaseMaterialCode> orgInfoMap = this.getPurchaseMaterialCode(elsAccount);
        for (Object object : ItemList) {
            PurchaseMaterialCode materialCode;
            JSONObject item = (JSONObject)object;
            String cateCode = item.getString("CATEGORY_ID");
            String cateName = item.getString("CATEGORY2");
            String upCateCode = item.getString("CATEGORY1");
            String updateTime = item.getString("UPDATE_TIME");
            if (orgInfoMap.containsKey(cateName)) {
                materialCode = orgInfoMap.get(cateName);
                materialCode.setCateCode(cateCode);
                materialCode.setCateName(cateName);
                materialCode.setUpCateCode(upCateCode);
                materialCode.setUpdateTime(OracleSqlUtil.getUpdateTime((String)updateTime));
                updateAccount.add(materialCode);
                continue;
            }
            materialCode = new PurchaseMaterialCode();
            materialCode.setId(IdWorker.getIdStr());
            materialCode.setElsAccount(elsAccount);
            materialCode.setCateStatus("1");
            materialCode.setSourceType("1");
            materialCode.setSourceSystem("oracle");
            materialCode.setDeleted(CommonConstant.DEL_FLAG_0);
            materialCode.setUpdateTime(OracleSqlUtil.getUpdateTime((String)updateTime));
            materialCode.setCateCode(cateCode);
            materialCode.setCateName(cateName);
            materialCode.setUpCateCode(upCateCode);
            insertAccount.add(materialCode);
            orgInfoMap.put(cateName, materialCode);
        }
        if (CollectionUtil.isNotEmpty(insertAccount)) {
            for (PurchaseMaterialCode materialCode : insertAccount) {
                if (!StrUtil.isNotBlank((CharSequence)materialCode.getUpCateCode()) || (info = orgInfoMap.get(materialCode.getUpCateCode())) == null) continue;
                materialCode.setUpCateName(info.getCateName());
            }
            this.purchaseMaterialCodeService.saveBatch(insertAccount, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateAccount)) {
            for (PurchaseMaterialCode materialCode : updateAccount) {
                if (!StrUtil.isNotBlank((CharSequence)materialCode.getUpCateCode()) || (info = orgInfoMap.get(materialCode.getUpCateCode())) == null) continue;
                materialCode.setUpCateName(info.getCateName());
            }
            this.purchaseMaterialCodeService.updateBatchById(updateAccount, 2000);
        }
        return interfaceResult;
    }

    private Map<String, PurchaseMaterialCode> getPurchaseMaterialCode(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        List list = this.purchaseMaterialCodeService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseMaterialCode>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateName, Function.identity(), (newVal, oldVal) -> oldVal));
    }
}

