/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.rpc.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.util.SysUtil;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialItemDTO;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialHeadBeanServiceImpl
implements PurchaseMaterialHeadRpcService {
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Autowired
    private PurchaseMaterialUnitService purchaseMaterialUnitService;

    public List<PurchaseMaterialHeadDTO> selectCheckQuantityMaterialByNumbers(List<String> materialNumberLis) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseMaterialHead::getCheckQuality, (Object)"1");
        wrapper.in(PurchaseMaterialHead::getMaterialNumber, materialNumberLis);
        List list = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
        return SysUtil.copyProperties((List)list, PurchaseMaterialHeadDTO.class);
    }

    public void updateById(PurchaseMaterialHeadDTO headDTO) {
        PurchaseMaterialHead head = (PurchaseMaterialHead)SysUtil.copyProperties((Object)headDTO, PurchaseMaterialHead.class);
        this.purchaseMaterialHeadService.updateById((Object)head);
    }

    public List<PurchaseMaterialHeadDTO> listByMaterialNumbers(List<String> materialNumberList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PurchaseMaterialHead::getMaterialNumber, materialNumberList);
        List list = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
        return SysUtil.copyProperties((List)list, PurchaseMaterialHeadDTO.class);
    }

    public void saveMain(PurchaseMaterialHeadDTO headDTO, List<PurchaseMaterialItemDTO> itemDTOList, List<PurchaseMaterialUnitDTO> purchaseMaterialUnitList) {
        PurchaseMaterialHead head = (PurchaseMaterialHead)SysUtil.copyProperties((Object)headDTO, PurchaseMaterialHead.class);
        ArrayList itemList = SysUtil.copyProperties(itemDTOList, PurchaseMaterialItem.class);
        ArrayList unitList = SysUtil.copyProperties(purchaseMaterialUnitList, PurchaseMaterialUnit.class);
        this.purchaseMaterialHeadService.saveMain(head, (List)itemList, (List)unitList);
    }

    public PurchaseMaterialHeadDTO getMaterialHeadByNumber(String materialNumber) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)materialNumber)).last("limit 1");
        PurchaseMaterialHead one = (PurchaseMaterialHead)this.purchaseMaterialHeadService.getOne((Wrapper)wrapper);
        if (null == one) {
            return null;
        }
        return (PurchaseMaterialHeadDTO)Convert.convert(PurchaseMaterialHeadDTO.class, (Object)one);
    }

    public List<PurchaseMaterialItemDTO> selectByMainIdAndFactory(String id, String factory) {
        List list = this.purchaseMaterialItemService.selectByMainId(id).stream().filter(item -> factory.equals(item.getFactory())).collect(Collectors.toList());
        return SysUtil.copyProperties(list, PurchaseMaterialItemDTO.class);
    }

    public void update(PurchaseMaterialHeadDTO purchaseMaterialHeadDTO, List<String> materialNumberList) {
        PurchaseMaterialHead head = (PurchaseMaterialHead)SysUtil.copyProperties((Object)purchaseMaterialHeadDTO, PurchaseMaterialHead.class);
        this.purchaseMaterialHeadService.update((Object)head, (Wrapper)new LambdaUpdateWrapper().in(PurchaseMaterialHead::getMaterialNumber, materialNumberList));
    }

    public List<PurchaseMaterialUnitDTO> selectUnitByMaterialIds(List<String> materialIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PurchaseMaterialUnit::getHeadId, materialIds);
        List list = new ArrayList();
        if (CollectionUtil.isNotEmpty(materialIds)) {
            list = this.purchaseMaterialUnitService.list((Wrapper)wrapper);
            return SysUtil.copyProperties(list, PurchaseMaterialUnitDTO.class);
        }
        return SysUtil.copyProperties(list, PurchaseMaterialUnitDTO.class);
    }

    public List<PurchaseMaterialUnitDTO> selectByMain(String id) {
        return SysUtil.copyProperties((List)this.purchaseMaterialUnitService.selectByMainId(id), PurchaseMaterialUnitDTO.class);
    }

    public List<PurchaseMaterialUnitDTO> selectByMaterialNumber(String number) {
        return SysUtil.copyProperties((List)this.purchaseMaterialUnitService.selectByMaterialNumber(number), PurchaseMaterialUnitDTO.class);
    }
}

