/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.jdyxc;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.els.modules.third.base.enums.SourceTypeEnum;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialDataFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialDataFromXcDbImpl.class);
    private static final String MATERIAL_LIST = "/jdy/v2/bd/material";
    private static final String MATERIAL_DETAIL = "/jdy/v2/bd/material_detail";
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject customObject = (JSONObject)custom;
        JSONObject urlParam = obj.getJSONObject("url_param");
        if (obj.getJSONObject("url_param") == null) {
            urlParam = new JSONObject();
            urlParam.put("page", (Object)1);
            urlParam.put("page_size", (Object)"100");
            boolean isIncrement = true;
            if (customObject.getBoolean("isIncrement") != null) {
                isIncrement = customObject.getBoolean("isIncrement");
            }
            if (isIncrement) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, 0);
                calendar.set(5, 1);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
                try {
                    urlParam.put("modify_start_time", (Object)sdf.parse(sdf.format(calendar.getTime())).getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            obj.put("url_param", (Object)urlParam);
        }
        customObject.put("url_param", (Object)urlParam);
        return this.getSendJSON(obj, customObject, MATERIAL_LIST);
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        log.info("GetMaterialDataFromXcV2DbImpl -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj));
        List resultData = JSON.parseArray((String)JSONArray.toJSONString((Object)this.handlerHeadResultListInfoV2(obj), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Map.class);
        if (CollUtil.isEmpty((Collection)resultData)) {
            obj.put("message", (Object)"\u6682\u65e0\u7269\u6599\u5206\u7c7b\u6570\u636e\u9700\u8981\u540c\u6b65");
            return obj;
        }
        TemplateHeadDTO template = ThirdUtil.getTemplateHeadDTO((String)"material");
        resultData = ThirdUtil.getFieldMapping((List)resultData, (String)elsAccount, (String)"getMaterialData", null);
        String[] fieldMapping = ThirdUtil.getFieldMapping((String)elsAccount, (String)"getMaterialData", null);
        ArrayList<PurchaseMaterialHead> headData = new ArrayList<PurchaseMaterialHead>();
        for (Map data : resultData) {
            PurchaseMaterialHead material = (PurchaseMaterialHead)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseMaterialHead.class);
            material.setElsAccount(elsAccount);
            material.setTemplateName(template.getTemplateName());
            material.setTemplateNumber(template.getTemplateNumber());
            material.setTemplateVersion(template.getTemplateVersion());
            material.setTemplateAccount(template.getElsAccount());
            material.setSourceType(SourceTypeEnum.ERP.getDesc());
            material.setSourceSystem(ThirdTypeEnum.THIRD_JD_XC.getValue());
            material.setBlocDel("0");
            material.setFreeze("0");
            headData.add(material);
        }
        Integer saveLeven = 1;
        String sourceType = "ERP";
        this.purchaseMaterialHeadService.batchSaveMain((List)SysUtil.copyProperties(headData, PurchaseMaterialHeadVO.class), new ArrayList<String>(Arrays.asList(fieldMapping)), saveLeven, sourceType);
        this.getPageInfo(obj, custom);
        return obj;
    }
}

