/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.jdyxc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.enumerate.PurchaseOrgCategoryStatus;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetDepartmentFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetDepartmentFromXcDbImpl.class);
    private static final String DEPARTMENT_LIST = "/jdy/v2/bd/department";
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    public JSONObject before(JSONObject obj, Object custom) {
        return this.getSendJSON(obj, custom, DEPARTMENT_LIST);
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        log.info("GetDepartmentFromXcDbImpl -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj));
        List resultData = JSON.parseArray((String)JSONArray.toJSONString((Object)this.handlerHeadResultListInfoV2(obj), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Map.class);
        if (CollUtil.isEmpty((Collection)resultData)) {
            obj.put("message", (Object)"\u6682\u65e0\u90e8\u95e8\u6570\u636e\u9700\u8981\u540c\u6b65");
            return obj;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getSourceId}).in(PurchaseOrganizationInfo::getOrgCategoryCode, Arrays.asList(PurchaseOrgCategoryStatus.COMPANY_CODE.getValue(), PurchaseOrgCategoryStatus.DEPT.getValue()))).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)0);
        List list = this.purchaseOrganizationInfoService.list((Wrapper)wrapper);
        Map<String, String> dbMap = list.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getSourceId())).collect(Collectors.toMap(BaseEntity::getId, PurchaseOrganizationInfo::getSourceId));
        ArrayList<String> dbSourceIds = new ArrayList<String>(dbMap.values());
        resultData = ThirdUtil.getFieldMapping((List)resultData, (String)elsAccount, (String)"getDeptData", null);
        Map resultDataMap = resultData.stream().collect(Collectors.toMap(o -> o.get("sourceId").toString(), Function.identity()));
        Set<String> sourceIds = resultDataMap.keySet();
        if (CollUtil.isNotEmpty(dbSourceIds)) {
            dbSourceIds.forEach(sourceIds::remove);
        }
        TemplateHeadDTO template = ThirdUtil.getTemplateHeadDTO((String)"org");
        ArrayList<PurchaseOrganizationInfo> purchaseOrganizationInfos = new ArrayList<PurchaseOrganizationInfo>();
        for (String sourceId2 : sourceIds) {
            String insertId = IdWorker.getIdStr();
            dbMap.put(insertId, sourceId2);
            Map map = (Map)resultDataMap.get(sourceId2);
            PurchaseOrganizationInfo purchaseOrganizationInfo = (PurchaseOrganizationInfo)JSON.parseObject((String)JSON.toJSONString((Object)map), PurchaseOrganizationInfo.class);
            purchaseOrganizationInfo.setTemplateNumber(template.getTemplateNumber());
            purchaseOrganizationInfo.setTemplateName(template.getTemplateName());
            purchaseOrganizationInfo.setTemplateVersion(template.getTemplateVersion());
            purchaseOrganizationInfo.setTemplateAccount(template.getElsAccount());
            purchaseOrganizationInfo.setId(insertId);
            purchaseOrganizationInfo.setElsAccount(elsAccount);
            PurchaseOrgCategoryStatus enums = PurchaseOrgCategoryStatus.DEPT;
            if ("0".equals(purchaseOrganizationInfo.getExecutiveLevel())) {
                enums = PurchaseOrgCategoryStatus.COMPANY_CODE;
                purchaseOrganizationInfo.setSuperExecutiveId(null);
            }
            purchaseOrganizationInfo.setOrgCategoryCode(enums.getValue());
            purchaseOrganizationInfo.setOrgCategoryDesc(enums.getDesc());
            purchaseOrganizationInfo.setOrgNature("1");
            purchaseOrganizationInfo.setEnableTime(new Date());
            purchaseOrganizationInfo.setSourceSystem(ThirdTypeEnum.THIRD_JD_XC.getValue());
            purchaseOrganizationInfo.setSourceType("1");
            purchaseOrganizationInfos.add(purchaseOrganizationInfo);
        }
        for (PurchaseOrganizationInfo purchaseOrganizationInfo : purchaseOrganizationInfos) {
            Map map = (Map)resultDataMap.get(purchaseOrganizationInfo.getSourceId());
            PurchaseOrganizationInfo info = (PurchaseOrganizationInfo)JSON.parseObject((String)JSON.toJSONString((Object)map), PurchaseOrganizationInfo.class);
            String superExecutiveId = info.getSuperExecutiveId();
            dbMap.forEach((id, sourceId) -> {
                if (StringUtils.isNotBlank((CharSequence)sourceId) && sourceId.equals(superExecutiveId)) {
                    purchaseOrganizationInfo.setSuperExecutiveId(id);
                }
            });
        }
        this.purchaseOrganizationInfoService.saveBatch(purchaseOrganizationInfos, 200);
        return obj;
    }
}

