/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.service.PurchaseInformationRecordsRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseInformationRecordsBeanServiceImpl
implements PurchaseInformationRecordsRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;

    public void addBatch(List<PurchaseInformationRecordsDTO> list) {
        this.purchaseInformationRecordsService.addBatch((List)SysUtil.copyProperties(list, PurchaseInformationRecords.class));
    }

    public void insertBatchSomeColumn(List<PurchaseInformationRecordsDTO> purchaseInformationRecordsDTOList) {
        if (CollectionUtil.isNotEmpty(purchaseInformationRecordsDTOList)) {
            this.purchaseInformationRecordsService.saveBatch((Collection)SysUtil.copyProperties(purchaseInformationRecordsDTOList, PurchaseInformationRecords.class));
        }
    }

    public void cancelBySourceNumber(String sourceType, String sourceNumber, List<String> itemNumberList) {
        this.purchaseInformationRecordsService.cancelBySourceNumber(sourceType, sourceNumber, itemNumberList);
    }

    public PurchaseInformationRecordsDTO getEffectiveRecord(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        PurchaseInformationRecordsDTO purchaseInformationRecordsDTO = null;
        PurchaseInformationRecords purchaseInformationRecords = this.purchaseInformationRecordsService.getEffectiveRecord(materialNumber, materialGroup, factory, purchaseOrg, toElsAccount);
        if (purchaseInformationRecords != null) {
            purchaseInformationRecordsDTO = (PurchaseInformationRecordsDTO)SysUtil.copyProperties((Object)purchaseInformationRecords, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTO;
    }

    public List<PurchaseInformationRecordsDTO> getEffectiveRecordList(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        List effectiveRecordList = this.purchaseInformationRecordsService.getEffectiveRecordList(materialNumber, materialGroup, factory, purchaseOrg, toElsAccount);
        ArrayList purchaseInformationRecordsDTOList = null;
        if (CollectionUtil.isNotEmpty((Collection)effectiveRecordList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)effectiveRecordList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    public List<PurchaseInformationRecordsDTO> selectList(List<String> toElsAccounts, String auditStatus, String recordStatus, Date effectiveDate, Date expiryDate, String materialNumber, String purchaseOrg, String factory) {
        List purchaseInformationRecordsList = null;
        QueryWrapper purchaseInformationRecordsQueryWrapper = new QueryWrapper();
        purchaseInformationRecordsQueryWrapper.in(CollectionUtil.isNotEmpty(toElsAccounts), (Object)"to_els_account", toElsAccounts);
        purchaseInformationRecordsQueryWrapper.in((Object)"audit_status", Arrays.asList(AuditStatusEnum.AUDIT_FINISH.getValue(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()));
        purchaseInformationRecordsQueryWrapper.and(qw -> ((QueryWrapper)qw.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or(qw1 -> qw1.eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue())));
        purchaseInformationRecordsQueryWrapper.le((Object)"effective_date", (Object)DateUtil.beginOfDay((Date)new Date()));
        purchaseInformationRecordsQueryWrapper.ge((Object)"expiry_date", (Object)DateUtil.beginOfDay((Date)new Date()));
        purchaseInformationRecordsQueryWrapper.eq((Object)"material_number", (Object)materialNumber);
        purchaseInformationRecordsQueryWrapper.eq((Object)"purchase_org", (Object)purchaseOrg);
        purchaseInformationRecordsQueryWrapper.and(StrUtil.isNotBlank((CharSequence)factory), qw -> ((QueryWrapper)((QueryWrapper)qw.eq((Object)"factory", (Object)factory)).or(qw2 -> qw2.eq((Object)"factory", (Object)""))).or(qw1 -> qw1.isNull((Object)"factory")));
        purchaseInformationRecordsQueryWrapper.orderByAsc((Object)"price");
        purchaseInformationRecordsList = this.purchaseInformationRecordsService.list((Wrapper)purchaseInformationRecordsQueryWrapper);
        List purchaseInformationRecordsDTOList = Collections.EMPTY_LIST;
        if (CollectionUtil.isNotEmpty((Collection)purchaseInformationRecordsList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)purchaseInformationRecordsList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    public List<PurchaseInformationRecordsDTO> selectListNoOrg(String auditStatus, String recordStatus, Date effectiveDate, Date expiryDate, List<String> materialNumbers) {
        QueryWrapper informationRecordsQueryWrapper = new QueryWrapper();
        informationRecordsQueryWrapper.in((Object)"material_number", materialNumbers);
        informationRecordsQueryWrapper.in((Object)"audit_status", Arrays.asList(AuditStatusEnum.AUDIT_FINISH.getValue(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()));
        informationRecordsQueryWrapper.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue());
        informationRecordsQueryWrapper.le((Object)"effective_date", (Object)new Date());
        informationRecordsQueryWrapper.ge((Object)"expiry_date", (Object)new Date());
        informationRecordsQueryWrapper.last("and purchase_org is not null and purchase_org!='' ");
        List purchaseInformationRecordList = this.purchaseInformationRecordsService.list((Wrapper)informationRecordsQueryWrapper);
        ArrayList purchaseInformationRecordsDTOList = null;
        if (CollectionUtil.isNotEmpty((Collection)purchaseInformationRecordList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)purchaseInformationRecordList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    public void cutOffPriceDate(PurchaseInformationRecordsDTO records) {
        PurchaseInformationRecords informationRecords = (PurchaseInformationRecords)Convert.convert(PurchaseInformationRecords.class, (Object)records);
        this.purchaseInformationRecordsService.cutOffPriceDate(informationRecords, false);
    }

    public void cutOffPriceDates(List<PurchaseInformationRecordsDTO> records) {
        List list = Convert.toList(PurchaseInformationRecords.class, records);
        list.forEach(r -> this.purchaseInformationRecordsService.cutOffPriceDate(r, false));
    }

    public void checkPriceIfExistByBidding(PurchaseInformationRecordsDTO recordsDTO) {
        PurchaseInformationRecords records = (PurchaseInformationRecords)Convert.convert(PurchaseInformationRecords.class, (Object)recordsDTO);
        records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
        boolean exist = this.purchaseInformationRecordsService.checkPriceIfCreateByType(records);
        if (exist) {
            throw new ELSBootException(String.format("%s:%s %s", records.getSourceNumber(), records.getSourceItemNumber(), I18nUtil.translate((String)"i18n_alert_umtHIObL_8def9438", (String)"\u4ef7\u683c\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\uff01")));
        }
    }

    public List<String> checkPriceForSome(List<String> stringList) {
        return this.purchaseInformationRecordsService.checkPriceForSome(stringList);
    }

    public List<PurchaseInformationRecordsDTO> generatePrice(TemplateHeadDTO templateHeadDTO, PurchaseContractHeadDTO head, List<PurchaseContractItemDTO> contractItems) {
        List purchaseInformationRecords = this.purchaseInformationRecordsService.generatePrice(templateHeadDTO, head, contractItems);
        return SysUtil.copyProperties((List)purchaseInformationRecords, PurchaseInformationRecordsDTO.class);
    }

    public void setPurchaseInformationRecordsQuantityAmount(List<PurchaseOrderItemDTO> arrayList) {
        List priceRecordNumberList = arrayList.stream().map(PurchaseOrderItemDTO::getPriceRecordNumber).distinct().collect(Collectors.toList());
        Map<String, List<PurchaseOrderItemDTO>> stringListMap = arrayList.stream().collect(Collectors.groupingBy(PurchaseOrderItemDTO::getPriceRecordNumber));
        List informationRecordsList = ((LambdaQueryChainWrapper)this.purchaseInformationRecordsService.lambdaQuery().in(PurchaseInformationRecords::getInfoRecordNumber, priceRecordNumberList)).list();
        Map informationRecordsMap = informationRecordsList.stream().collect(Collectors.toMap(PurchaseInformationRecords::getInfoRecordNumber, Function.identity()));
        for (String priceRecordNumber : stringListMap.keySet()) {
            List<PurchaseOrderItemDTO> itemDTOList = stringListMap.get(priceRecordNumber);
            PurchaseInformationRecords informationRecords = (PurchaseInformationRecords)informationRecordsMap.get(priceRecordNumber);
            BigDecimal totalQuantity = informationRecords.getAccumulatedProcurementQuantity() == null ? BigDecimal.ZERO : informationRecords.getAccumulatedProcurementQuantity();
            BigDecimal totalTaxAmount = informationRecords.getAccumulatedPurchaseAmount() == null ? BigDecimal.ZERO : informationRecords.getAccumulatedPurchaseAmount();
            for (PurchaseOrderItemDTO orderItemDTO : itemDTOList) {
                totalQuantity = totalQuantity.add(orderItemDTO.getQuantity());
                totalTaxAmount = totalTaxAmount.add(orderItemDTO.getTaxAmount());
            }
            informationRecords.setAccumulatedPurchaseAmount(totalTaxAmount);
            informationRecords.setAccumulatedProcurementQuantity(totalQuantity);
        }
        this.purchaseInformationRecordsService.updateBatchById((Collection)informationRecordsList);
    }
}

