/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.extend;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DateUtils;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.enumerate.MaterialPurchaseTypeEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GetMaterialFromShiWeiU8Impl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialFromShiWeiU8Impl.class);
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    @Resource
    private PurchaseMaterialUnitService purchaseMaterialUnitService;
    @Resource
    private BaseRpcService baseRpcService;
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    private TemplateRpcService templateRpcService;

    public JSONObject before(JSONObject obj, Object custom) {
        String erpModifyDate;
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        JSONObject body = new JSONObject();
        boolean isIncrement = true;
        String updateTimeBegin = "";
        String updateTimeEnd = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59";
        if (customObj.containsKey((Object)"custom_param") && null != customObj.getJSONObject("custom_param")) {
            JSONObject customParam = customObj.getJSONObject("custom_param");
            isIncrement = customParam.getBoolean("isIncrement");
            if (StringUtils.isNotBlank((CharSequence)customParam.getString("updateTimeBegin"))) {
                updateTimeBegin = customParam.getString("updateTimeBegin");
            }
            if (StringUtils.isNotBlank((CharSequence)customParam.getString("updateTimeEnd"))) {
                updateTimeEnd = customParam.getString("updateTimeEnd");
            }
        }
        if (isIncrement && StringUtils.isNotBlank((CharSequence)(erpModifyDate = (String)this.purchaseMaterialHeadService.getMap((Wrapper)new QueryWrapper().select(new String[]{"IFNULL(max(fbk11), '') as erpModifyDate"}).eq((Object)"els_account", (Object)elsAccount)).get("erpModifyDate")))) {
            updateTimeBegin = erpModifyDate;
        }
        body.put("updateTimeBegin", (Object)updateTimeBegin);
        body.put("updateTimeEnd", (Object)updateTimeEnd);
        obj.put("body", (Object)body);
        log.info("GetMaterialFromShiWeiU8Impl before -> obj \u3010{}\u3011 custom \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj), custom);
        return obj;
    }

    public JSONObject after(JSONObject result, JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        if (result.getIntValue("code") != 200) {
            throw new ELSBootException(result.getString("message"));
        }
        JSONObject result2 = result.getJSONObject("result");
        if (!result2.getBooleanValue("IsSucceed")) {
            throw new ELSBootException(result2.getString("Dsc"));
        }
        JSONArray dataList = result2.getJSONArray("data");
        if (CollUtil.isEmpty((Collection)dataList)) {
            result.put("message", (Object)"\u6682\u65e0\u7269\u6599\u6570\u636e\u9700\u8981\u540c\u6b65");
            return result;
        }
        log.info("GetMaterialFromShiWeiU8Impl after -> data size \u3010{}\u3011", (Object)dataList.size());
        List templateList = this.templateRpcService.getDefaultTemplateByType("material");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f");
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
        Map codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity()));
        List materialNumbers = dataList.stream().map(o -> ((JSONObject)o).getString("materialNumber")).distinct().collect(Collectors.toList());
        Map<Object, Object> materialMap = new HashMap();
        if (CollectionUtil.isNotEmpty(materialNumbers)) {
            LambdaQueryWrapper materialWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseMaterialHead::getBlocDel, (Object)"0")).in(PurchaseMaterialHead::getMaterialNumber, materialNumbers);
            materialMap = this.purchaseMaterialHeadService.list((Wrapper)materialWrapper).stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        }
        ArrayList<PurchaseMaterialHead> saveList = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialHead> updateList = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialUnit> unitList = new ArrayList<PurchaseMaterialUnit>();
        for (Object data : dataList) {
            JSONObject object = (JSONObject)data;
            if (StringUtils.isNotBlank((CharSequence)object.getString("createTime"))) {
                object.put("createTime", (Object)DateUtil.parseDateTime((CharSequence)object.getString("createTime")));
            }
            if (StringUtils.isNotBlank((CharSequence)object.getString("updateTime"))) {
                object.put("updateTime", (Object)DateUtil.parseDateTime((CharSequence)object.getString("updateTime")));
            }
            PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)ConvertUtils.convertDefault(PurchaseMaterialHead.class, (JSONObject)object, (Map)headDefaultValue);
            purchaseMaterialHead.setTemplateNumber(template.getTemplateNumber());
            purchaseMaterialHead.setTemplateName(template.getTemplateName());
            purchaseMaterialHead.setTemplateAccount(template.getElsAccount());
            purchaseMaterialHead.setTemplateVersion(template.getTemplateVersion());
            purchaseMaterialHead.setNeedAudit("0");
            purchaseMaterialHead.setSubmitStatus("0");
            purchaseMaterialHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            purchaseMaterialHead.setSourceType("erp");
            purchaseMaterialHead.setBlocDel("0");
            purchaseMaterialHead.setFreeze("0");
            String materialNumber = purchaseMaterialHead.getMaterialNumber();
            purchaseMaterialHead.setMaterialDesc(purchaseMaterialHead.getMaterialName());
            if (StringUtils.isBlank((CharSequence)purchaseMaterialHead.getPurchaseUnit())) {
                purchaseMaterialHead.setPurchaseUnit(purchaseMaterialHead.getBaseUnit());
            }
            purchaseMaterialHead.setCheckQuality("True".equals(purchaseMaterialHead.getCheckQuality()) ? "1" : "0");
            purchaseMaterialHead.setFbk1("True".equals(purchaseMaterialHead.getFbk1()) ? "1" : "0");
            purchaseMaterialHead.setFbk2("True".equals(purchaseMaterialHead.getFbk2()) ? "1" : "0");
            if (purchaseMaterialHead.getUpdateTime() != null) {
                purchaseMaterialHead.setFbk11(DateUtil.formatDateTime((Date)purchaseMaterialHead.getUpdateTime()));
                purchaseMaterialHead.setUpdateTime(null);
            }
            purchaseMaterialHead.setDeliveryArrange("4");
            purchaseMaterialHead.setPurchaseType(MaterialPurchaseTypeEnum.EXTERNAL_PROCUREMENT.getValue());
            if (materialMap.get(materialNumber) == null) {
                purchaseMaterialHead.setId(IdWorker.getIdStr());
                saveList.add(purchaseMaterialHead);
            } else {
                purchaseMaterialHead.setId(((PurchaseMaterialHead)materialMap.get(materialNumber)).getId());
                updateList.add(purchaseMaterialHead);
            }
            unitList.addAll(this.generateUnit(purchaseMaterialHead));
        }
        if (!saveList.isEmpty()) {
            this.purchaseMaterialHeadService.saveBatch(saveList, 2000);
        }
        if (!updateList.isEmpty()) {
            this.purchaseMaterialHeadService.updateBatchById(updateList, 2000);
            List headIdList = updateList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            this.purchaseMaterialUnitService.deleteByMainIdList(headIdList);
        }
        if (CollectionUtil.isNotEmpty(unitList)) {
            this.purchaseMaterialUnitService.saveBatch(unitList, 2000);
        }
        return result;
    }

    private List<PurchaseMaterialUnit> generateUnit(PurchaseMaterialHead purchaseMaterialHead) {
        ArrayList<PurchaseMaterialUnit> purchaseMaterialUnitList = new ArrayList<PurchaseMaterialUnit>();
        PurchaseMaterialUnit purchaseUnit = new PurchaseMaterialUnit();
        purchaseUnit.setType("0");
        purchaseUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
        purchaseUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
        purchaseUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
        purchaseUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
        purchaseUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
        purchaseUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
        purchaseUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
        purchaseUnit.setDeleted(purchaseMaterialHead.getDeleted());
        purchaseUnit.setBasicAmount(BigDecimal.ONE);
        purchaseUnit.setObjectAmount(BigDecimal.ONE);
        purchaseUnit.setChangeUnit("=");
        purchaseUnit.setIsDefault("1");
        purchaseUnit.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseUnit.setHeadId(purchaseMaterialHead.getId());
        purchaseMaterialUnitList.add(purchaseUnit);
        PurchaseMaterialUnit repertoryUnit = new PurchaseMaterialUnit();
        repertoryUnit.setType("1");
        repertoryUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
        repertoryUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
        repertoryUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
        repertoryUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
        repertoryUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
        repertoryUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
        repertoryUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
        repertoryUnit.setDeleted(purchaseMaterialHead.getDeleted());
        repertoryUnit.setBasicAmount(BigDecimal.ONE);
        repertoryUnit.setObjectAmount(BigDecimal.ONE);
        repertoryUnit.setChangeUnit("=");
        repertoryUnit.setIsDefault("1");
        repertoryUnit.setDeleted(CommonConstant.DEL_FLAG_0);
        repertoryUnit.setHeadId(purchaseMaterialHead.getId());
        purchaseMaterialUnitList.add(repertoryUnit);
        return purchaseMaterialUnitList;
    }
}

