/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.dingding;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.enumerate.PurchaseOrgCategoryStatus;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.dingding.util.DingDingBusinessManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetDepartmentFromShiWeiImpl
extends DingDingBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetDepartmentFromShiWeiImpl.class);
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String deptId = customObj.getString("dept_id");
        JSONObject body = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)deptId)) {
            body.put("dept_id", (Object)deptId);
        }
        obj.put("body", (Object)body);
        log.info("GetDepartmentFromShiWeiImpl -> obj \u3010{}\u3011 custom \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj), custom);
        return this.getSendJSON(obj, custom);
    }

    public JSONObject after(JSONObject result, JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        log.info("GetDepartmentFromShiWeiImpl -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj));
        JSONObject resultObject = this.handlerResult(result);
        JSONArray resultData = resultObject.getJSONArray("result");
        if (CollUtil.isEmpty((Collection)resultData)) {
            result.put("message", (Object)"\u6682\u65e0\u90e8\u95e8\u6570\u636e\u9700\u8981\u540c\u6b65");
            return result;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getSourceId, PurchaseOrganizationInfo::getOrgCategoryCode}).in(PurchaseOrganizationInfo::getOrgCategoryCode, Arrays.asList(PurchaseOrgCategoryStatus.COMPANY_CODE.getValue(), PurchaseOrgCategoryStatus.DEPT.getValue()))).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)0);
        List list = this.purchaseOrganizationInfoService.list((Wrapper)wrapper);
        Map<String, String> dbMap = list.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getSourceId())).collect(Collectors.toMap(BaseEntity::getId, PurchaseOrganizationInfo::getSourceId));
        List companyList = list.stream().filter(o -> PurchaseOrgCategoryStatus.COMPANY_CODE.getValue().equals(o.getOrgCategoryCode())).collect(Collectors.toList());
        PurchaseOrganizationInfo company = null;
        if (CollUtil.isNotEmpty(companyList)) {
            company = (PurchaseOrganizationInfo)companyList.get(0);
        }
        ArrayList<String> dbSourceIds = new ArrayList<String>(dbMap.values());
        Map resultDataMap = resultData.stream().collect(Collectors.toMap(o -> ((JSONObject)o).getString("dept_id"), Function.identity()));
        HashSet<String> resultSourceIds = new HashSet<String>(resultDataMap.keySet());
        if (CollUtil.isNotEmpty(dbSourceIds)) {
            dbSourceIds.forEach(resultSourceIds::remove);
        }
        TemplateHeadDTO template = ThirdUtil.getTemplateHeadDTO((String)"org");
        ArrayList<PurchaseOrganizationInfo> purchaseOrganizationInfos = new ArrayList<PurchaseOrganizationInfo>();
        for (String sourceId2 : resultSourceIds) {
            String insertId = IdWorker.getIdStr();
            dbMap.put(insertId, sourceId2);
            JSONObject data = (JSONObject)resultDataMap.get(sourceId2);
            PurchaseOrganizationInfo purchaseOrganizationInfo = new PurchaseOrganizationInfo();
            purchaseOrganizationInfo.setTemplateNumber(template.getTemplateNumber());
            purchaseOrganizationInfo.setTemplateName(template.getTemplateName());
            purchaseOrganizationInfo.setTemplateVersion(template.getTemplateVersion());
            purchaseOrganizationInfo.setTemplateAccount(template.getElsAccount());
            purchaseOrganizationInfo.setId(insertId);
            purchaseOrganizationInfo.setElsAccount(elsAccount);
            purchaseOrganizationInfo.setOrgCode(data.getString("dept_id"));
            purchaseOrganizationInfo.setOrgName(data.getString("name"));
            purchaseOrganizationInfo.setOrgAbbreviation(data.getString("name"));
            if ("1".equals(data.getString("parent_id"))) {
                purchaseOrganizationInfo.setSuperBusinessId(company != null ? company.getId() : null);
            }
            purchaseOrganizationInfo.setOrgCategoryCode(PurchaseOrgCategoryStatus.DEPT.getValue());
            purchaseOrganizationInfo.setOrgCategoryDesc(PurchaseOrgCategoryStatus.DEPT.getDesc());
            purchaseOrganizationInfo.setOrgNature("0");
            purchaseOrganizationInfo.setEnableTime(new Date());
            purchaseOrganizationInfo.setSourceSystem(ThirdTypeEnum.DING_DING.getValue());
            purchaseOrganizationInfo.setSourceType("1");
            purchaseOrganizationInfo.setDataSource("1");
            purchaseOrganizationInfo.setStatus("1");
            purchaseOrganizationInfo.setSourceId(data.getString("dept_id"));
            purchaseOrganizationInfos.add(purchaseOrganizationInfo);
        }
        for (PurchaseOrganizationInfo purchaseOrganizationInfo : purchaseOrganizationInfos) {
            JSONObject data = (JSONObject)resultDataMap.get(purchaseOrganizationInfo.getSourceId());
            String superBusinessId = data.getString("parent_id");
            dbMap.forEach((id, sourceId) -> {
                if (StringUtils.isNotBlank((CharSequence)sourceId) && sourceId.equals(superBusinessId)) {
                    purchaseOrganizationInfo.setSuperBusinessId(id);
                }
            });
        }
        this.purchaseOrganizationInfoService.saveBatch(purchaseOrganizationInfos);
        for (String deptId : resultData.stream().map(i -> ((JSONObject)i).getString("dept_id")).collect(Collectors.toList())) {
            customObj.put("dept_id", (Object)deptId);
            this.getPageInfo(obj, custom);
        }
        return result;
    }
}

