/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.rpc.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.util.SysUtil;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.service.PurchaseMaterialSourceRpcService;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceBeanServiceImpl
implements PurchaseMaterialSourceRpcService {
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;

    public List<PurchaseMaterialSourceDTO> selectList(List<String> materialNumbers, String status, Date effectiveDate, Date expiryDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(PurchaseMaterialSource::getMaterialNumber, materialNumbers)).eq(PurchaseMaterialSource::getStatus, (Object)status)).le(PurchaseMaterialSource::getEffectiveDate, (Object)effectiveDate)).ge(PurchaseMaterialSource::getExpiryDate, (Object)effectiveDate);
        List sourceList = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
        return SysUtil.copyProperties((List)sourceList, PurchaseMaterialSourceDTO.class);
    }

    public void insertPurchaseMaterialSource(PurchaseMaterialSourceDTO purchaseMaterialSourceDTO) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)SysUtil.copyProperties((Object)purchaseMaterialSourceDTO, PurchaseMaterialSource.class);
        if (StringUtils.isNotEmpty((CharSequence)purchaseMaterialSource.getExtendFields()) && "1".equals(purchaseMaterialSource.getExtendFields())) {
            purchaseMaterialSource.setImportType(purchaseMaterialSource.getFbk1());
            purchaseMaterialSource.setFbk1(null);
            purchaseMaterialSource.setCheckContent(purchaseMaterialSource.getFbk2());
            purchaseMaterialSource.setFbk2(null);
            purchaseMaterialSource.setAgentToAlsAccount(purchaseMaterialSource.getFbk3());
            purchaseMaterialSource.setFbk3(null);
            purchaseMaterialSource.setAgentSupplierCode(purchaseMaterialSource.getFbk4());
            purchaseMaterialSource.setFbk4(null);
            purchaseMaterialSource.setAgentSupplierName(purchaseMaterialSource.getFbk5());
            purchaseMaterialSource.setFbk5(null);
            purchaseMaterialSource.setSapLibrary(purchaseMaterialSource.getFbk6());
            purchaseMaterialSource.setFbk6(null);
        }
        this.purchaseMaterialSourceService.save((Object)purchaseMaterialSource);
        this.purchaseMaterialSourceService.pushMatrialSourceToSap(Arrays.asList(purchaseMaterialSource), "0");
    }

    public List<PurchaseMaterialSourceDTO> selectSourceListByMaterialNumberPurchaseOrg(Collection<String> materialNumberPurchaseOrg) {
        Date currentDate = new Date();
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((QueryWrapper)wrapper.in((Object)"CONCAT(material_number,'_',purchase_org)", materialNumberPurchaseOrg)).lambda().eq(PurchaseMaterialSource::getStatus, (Object)5)).le(PurchaseMaterialSource::getEffectiveDate, (Object)currentDate)).ge(PurchaseMaterialSource::getExpiryDate, (Object)currentDate);
        List sourceList = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
        return SysUtil.copyProperties((List)sourceList, PurchaseMaterialSourceDTO.class);
    }
}

