/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.rpc.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.SysUtil;
import com.els.modules.extend.api.dto.PurchaseMaterialSourceExtendDTO;
import com.els.modules.extend.api.mainData.PurchaseMaterialSourceExtendRPCService;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceExtendRPCServiceImpl
implements PurchaseMaterialSourceExtendRPCService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialSourceExtendRPCServiceImpl.class);
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;

    @SrmTransaction
    public void frozenMaterialSources(List<String> toElsAccounts) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(PurchaseMaterialSource::getToElsAccount, toElsAccounts);
        List list = this.purchaseMaterialSourceService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return;
        }
        for (PurchaseMaterialSource purchaseMaterialSource : list) {
            purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.FROZEN.getValue());
        }
        this.purchaseMaterialSourceService.updateBatchById((Collection)list);
        this.purchaseMaterialSourceService.pushMatrialSourceToSap(list, "1");
    }

    public void insertPurchaseMaterialSource(PurchaseMaterialSourceExtendDTO purchaseMaterialSourceDTO) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)SysUtil.copyProperties((Object)purchaseMaterialSourceDTO, PurchaseMaterialSource.class);
        if (StringUtils.isNotEmpty((CharSequence)purchaseMaterialSource.getExtendFields()) && "1".equals(purchaseMaterialSource.getExtendFields())) {
            purchaseMaterialSource.setImportType(purchaseMaterialSource.getFbk1());
            purchaseMaterialSource.setFbk1(null);
            purchaseMaterialSource.setCheckContent(purchaseMaterialSource.getFbk2());
            purchaseMaterialSource.setFbk2(null);
            purchaseMaterialSource.setAgentToAlsAccount(purchaseMaterialSource.getFbk3());
            purchaseMaterialSource.setFbk3(null);
            purchaseMaterialSource.setAgentSupplierCode(purchaseMaterialSource.getFbk4());
            purchaseMaterialSource.setFbk4(null);
            purchaseMaterialSource.setAgentSupplierName(purchaseMaterialSource.getFbk5());
            purchaseMaterialSource.setFbk5(null);
            purchaseMaterialSource.setSapLibrary(purchaseMaterialSource.getFbk6());
            purchaseMaterialSource.setFbk6(null);
        }
        this.purchaseMaterialSourceService.save((Object)purchaseMaterialSource);
        if (StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getStatus()) && purchaseMaterialSource.getStatus().equals("2")) {
            this.purchaseMaterialSourceService.pushMatrialSourceToSap(Arrays.asList(purchaseMaterialSource), "1");
        } else {
            this.purchaseMaterialSourceService.pushMatrialSourceToSap(Arrays.asList(purchaseMaterialSource), "0");
        }
    }

    public void batchUpate(List<String> ids, String status) {
        List materialSources = this.purchaseMaterialSourceService.listByIds(ids);
        if (CollectionUtil.isEmpty((Collection)materialSources)) {
            return;
        }
        for (PurchaseMaterialSource materialSource : materialSources) {
            materialSource.setStatus(status);
        }
        this.purchaseMaterialSourceService.updateBatchById((Collection)materialSources);
        if (status.equals("2")) {
            this.purchaseMaterialSourceService.pushMatrialSourceToSap(materialSources, "1");
        } else {
            this.purchaseMaterialSourceService.pushMatrialSourceToSap(materialSources, "0");
        }
    }

    public void updateMaterialSouces1(String toElsAccount, String agentToAlsAccount, String materialNumber, String purchaseOrg, String factory, String company, String isFreeze) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseMaterialSource::getToElsAccount, (Object)toElsAccount)).eq(PurchaseMaterialSource::getAgentToAlsAccount, (Object)agentToAlsAccount)).eq(PurchaseMaterialSource::getMaterialNumber, (Object)materialNumber)).eq(PurchaseMaterialSource::getPurchaseOrg, (Object)purchaseOrg)).eq(PurchaseMaterialSource::getFactory, (Object)factory)).eq(PurchaseMaterialSource::getCompany, (Object)company)).le(PurchaseMaterialSource::getEffectiveDate, (Object)new Date())).ge(PurchaseMaterialSource::getExpiryDate, (Object)new Date());
        List materialSources = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)materialSources)) {
            return;
        }
        for (PurchaseMaterialSource materialSource : materialSources) {
            materialSource.setStatus(isFreeze.equals("0") ? "5" : "2");
        }
        this.purchaseMaterialSourceService.updateBatchById((Collection)materialSources);
        this.purchaseMaterialSourceService.pushMatrialSourceToSap(materialSources, isFreeze);
    }

    public void updateMaterialSouces2(String toElsAccount, String agentToAlsAccount, String materialGroup, String purchaseOrg, String factory, String company, String isFreeze) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseMaterialSource::getToElsAccount, (Object)toElsAccount)).eq(PurchaseMaterialSource::getAgentToAlsAccount, (Object)agentToAlsAccount)).eq(PurchaseMaterialSource::getMaterialGroup, (Object)materialGroup)).eq(PurchaseMaterialSource::getPurchaseOrg, (Object)purchaseOrg)).eq(PurchaseMaterialSource::getFactory, (Object)factory)).eq(PurchaseMaterialSource::getCompany, (Object)company)).le(PurchaseMaterialSource::getEffectiveDate, (Object)new Date())).ge(PurchaseMaterialSource::getExpiryDate, (Object)new Date());
        List materialSources = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)materialSources)) {
            return;
        }
        for (PurchaseMaterialSource materialSource : materialSources) {
            materialSource.setStatus(isFreeze.equals("0") ? "5" : "2");
        }
        this.purchaseMaterialSourceService.updateBatchById((Collection)materialSources);
        this.purchaseMaterialSourceService.pushMatrialSourceToSap(materialSources, isFreeze);
    }

    public List<PurchaseMaterialSourceDTO> selectList(String toElsAccount, String manufacturerElsAccount, String materialNumber, String materialGroup, String purchaseOrg, String factory, String company, String status) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseMaterialSource::getToElsAccount, (Object)manufacturerElsAccount)).eq(PurchaseMaterialSource::getAgentToAlsAccount, (Object)toElsAccount)).eq(PurchaseMaterialSource::getPurchaseOrg, (Object)purchaseOrg)).eq(PurchaseMaterialSource::getFactory, (Object)factory)).eq(PurchaseMaterialSource::getCompany, (Object)company)).eq(PurchaseMaterialSource::getStatus, (Object)status)).le(PurchaseMaterialSource::getEffectiveDate, (Object)new Date())).ge(PurchaseMaterialSource::getExpiryDate, (Object)new Date());
        List sourceList = null;
        if (!StringUtils.isBlank((CharSequence)materialGroup)) {
            wrapper.eq(PurchaseMaterialSource::getMaterialGroup, (Object)materialGroup);
            sourceList = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
        }
        if ((sourceList == null || sourceList.isEmpty()) && !StringUtils.isBlank((CharSequence)materialNumber)) {
            wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseMaterialSource::getToElsAccount, (Object)manufacturerElsAccount)).eq(PurchaseMaterialSource::getAgentToAlsAccount, (Object)toElsAccount)).eq(PurchaseMaterialSource::getMaterialNumber, (Object)materialNumber)).eq(PurchaseMaterialSource::getPurchaseOrg, (Object)purchaseOrg)).eq(PurchaseMaterialSource::getFactory, (Object)factory)).eq(PurchaseMaterialSource::getCompany, (Object)company)).eq(PurchaseMaterialSource::getStatus, (Object)status)).le(PurchaseMaterialSource::getEffectiveDate, (Object)new Date())).ge(PurchaseMaterialSource::getExpiryDate, (Object)new Date());
            sourceList = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
        }
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        return SysUtil.copyProperties((List)sourceList, PurchaseMaterialSourceDTO.class);
    }
}

