/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.mapper.PurchaseBomHeadMapper;
import com.els.modules.material.mapper.PurchaseBomItemMapper;
import com.els.modules.material.service.PurchaseBomHeadService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseBomHeadServiceImpl
extends ServiceImpl<PurchaseBomHeadMapper, PurchaseBomHead>
implements PurchaseBomHeadService {
    @Resource
    private PurchaseBomHeadMapper purchaseBomHeadMapper;
    @Resource
    private PurchaseBomItemMapper purchaseBomItemMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        this.purchaseBomHeadMapper.insert((Object)purchaseBomHead);
        this.insertData(purchaseBomHead, purchaseBomItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PurchaseBomHead::getMaterialNumber, (Object)purchaseBomHead.getMaterialNumber())).eq(PurchaseBomHead::getFactory, (Object)purchaseBomHead.getFactory())).eq(PurchaseBomHead::getVersion, (Object)purchaseBomHead.getVersion());
        PurchaseBomHead bomHead = (PurchaseBomHead)((Object)((PurchaseBomHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        Assert.isTrue((null == bomHead || bomHead.getId().equals(purchaseBomHead.getId()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWWWtFIOMK_2f383a6c", (String)"\u5f53\u524dBOM\u5355\u636e\u5df2\u7ecf\u5b58\u5728"));
        if ("0".equals(purchaseBomHead.getNeedAudit())) {
            purchaseBomHead.setAuditStatus("");
        }
        purchaseBomHead.setBomStatus(PurchaseBomStatus.NORMAL.getValue());
        this.purchaseBomHeadMapper.updateById((Object)purchaseBomHead);
        this.purchaseBomItemMapper.deleteByMainId(purchaseBomHead.getId());
        this.insertData(purchaseBomHead, purchaseBomItemList);
    }

    private void insertData(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        if (CollectionUtil.isNotEmpty(purchaseBomItemList)) {
            int itemNumber = 1;
            for (PurchaseBomItem entity : purchaseBomItemList) {
                entity.setHeadId(purchaseBomHead.getId());
                entity.setItemNumber(Integer.toString(itemNumber++));
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBomHead);
            }
            this.purchaseBomItemMapper.insertBatchSomeColumn(purchaseBomItemList);
        }
    }

    @Override
    public void frozenBom(String id) {
        this.purchaseBomHeadMapper.frozenBom(id);
    }

    @Override
    public void thawBom(String id) {
        this.purchaseBomHeadMapper.thawBom(id);
    }

    @Override
    public void cancelBom(String id) {
        this.purchaseBomHeadMapper.cancelBom(id);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBomItemMapper.deleteByMainId(id);
        this.purchaseBomHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBomItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBomHeadMapper.deleteById(serializable);
        }
    }
}

