/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.entity.TreeOrgNode;
import com.els.modules.org.enumerate.PurchaseOrgCategoryStatus;
import com.els.modules.org.enumerate.PurchaseOrganizationStatus;
import com.els.modules.org.mapper.PurchaseOrganizationInfoMapper;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseOrganizationInfoServiceImpl
extends ServiceImpl<PurchaseOrganizationInfoMapper, PurchaseOrganizationInfo>
implements PurchaseOrganizationInfoService {
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:dict:";
    private static final String COLON = ":";

    @Override
    public void savePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).insert((Object)purchaseOrganizationInfo);
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    public void updatePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        if ("0".equals(purchaseOrganizationInfo.getOrgNature())) {
            purchaseOrganizationInfo.setSuperExecutiveId("");
            purchaseOrganizationInfo.setExecutivePerson("");
            purchaseOrganizationInfo.setExecutiveDesc("");
            purchaseOrganizationInfo.setExecutiveRegion("");
            purchaseOrganizationInfo.setExecutiveLevel("");
            purchaseOrganizationInfo.setExecutiveOrder("");
        } else if ("1".equals(purchaseOrganizationInfo.getOrgNature())) {
            purchaseOrganizationInfo.setSuperBusinessId("");
            purchaseOrganizationInfo.setBusinessPerson("");
            purchaseOrganizationInfo.setBusinessDesc("");
            purchaseOrganizationInfo.setBusinessRegion("");
            purchaseOrganizationInfo.setBusinessLevel("");
            purchaseOrganizationInfo.setBusinessOrder("");
        }
        ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)purchaseOrganizationInfo);
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    public void delPurchaseOrganizationInfo(String id) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseOrganizationInfo(List<String> idList) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, Object> getSuperiorOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectByElsAccount(TenantContext.getTenant());
        ArrayList<TreeOrgNode> copyList = new ArrayList<TreeOrgNode>();
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
            TreeOrgNode newNode = new TreeOrgNode();
            SysUtil.copyProperties((Object)node, (Object)newNode);
            copyList.add(newNode);
        }
        List superBusinessList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperBusinessId()) && !"1".equals(o.getOrgNature())).collect(Collectors.toList());
        List superExecutiveList = copyList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId()) && !"0".equals(o.getOrgNature())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> businessCollect = list.parallelStream().filter(vo -> vo.getSuperBusinessId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperBusinessId));
        Map<String, List<TreeOrgNode>> executiveCollect = copyList.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superBusinessList) {
            this.forEach(businessCollect, node);
        }
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("business", superBusinessList);
        resultMap.put("executive", superExecutiveList);
        return resultMap;
    }

    @Override
    public List<TreeOrgNode> getExecutiveOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List<TreeOrgNode> superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> executiveCollect = list.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node);
        }
        return superExecutiveList;
    }

    @Override
    public List<TreeOrgNode> getFactoryOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrganization(TenantContext.getTenant(), "factory");
        list.forEach(node -> {
            node.setKey(node.getId());
            node.setValue(node.getId());
        });
        return list;
    }

    @Override
    public void frozen(String id, String status) {
        PurchaseOrganizationInfo org = new PurchaseOrganizationInfo();
        org.setId(id);
        org.setStatus(status);
        if (PurchaseOrganizationStatus.NORMAL.getValue().equals(status)) {
            org.setEnableTime(new Date());
        } else if (PurchaseOrganizationStatus.FROZEN.getValue().equals(status)) {
            org.setFreezeTime(new Date());
        }
        ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)org);
    }

    private void forEach(Map<String, List<TreeOrgNode>> collect, TreeOrgNode treeOrgNode) {
        List<TreeOrgNode> treeOrgNodelist = collect.get(treeOrgNode.getValue());
        if (collect.get(treeOrgNode.getValue()) != null) {
            treeOrgNode.setChildren(treeOrgNodelist);
            treeOrgNode.setHasChildren(true);
            treeOrgNode.getChildren().forEach(t -> this.forEach(collect, (TreeOrgNode)t));
        }
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgBySubAccount(String subAccount) {
        String elsAccount = TenantContext.getTenant();
        ElsSubAccountDTO subUser = this.invokeAccountRpcService.getAccount(elsAccount, subAccount);
        List<PurchaseOrganizationInfo> orgList = new ArrayList<PurchaseOrganizationInfo>();
        if (subUser != null && StringUtils.isNotBlank((CharSequence)subUser.getOrgCode())) {
            List<String> userOrgCodeId = Arrays.asList(subUser.getOrgCode().split(","));
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)orgWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(BaseEntity::getId, userOrgCodeId)).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
            orgList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)orgWrapper);
        }
        return orgList;
    }

    @Override
    public Map<String, String> getOrganizationByCode(String elsAccount, String orgCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)orgCode);
        List deptOrg = this.list((Wrapper)queryWrapper);
        return deptOrg.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, PurchaseOrganizationInfo::getOrgDesc));
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgForCalendar(String elsAccount, String orgCategoryCode) {
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrgCalendar(elsAccount, orgCategoryCode);
    }

    @Override
    public List<TreeOrgNode> getOrgCascader() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
        List orgList = this.list((Wrapper)queryWrapper);
        ArrayList<TreeOrgNode> orgTreeList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrganizationInfo org : orgList) {
            TreeOrgNode tree = new TreeOrgNode();
            tree.setKey(org.getId());
            tree.setTitle(org.getOrgName());
            tree.setValue(org.getOrgCode());
            tree.setOrgType(org.getOrgCategoryCode());
            orgTreeList.add(tree);
        }
        Map<String, List<TreeOrgNode>> orgMap = orgTreeList.stream().filter(vo -> StringUtils.isNotBlank((CharSequence)vo.getValue()) && StringUtils.isNotBlank((CharSequence)vo.getOrgType())).collect(Collectors.groupingBy(TreeOrgNode::getOrgType));
        ArrayList<TreeOrgNode> categoryList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrgCategoryStatus orgCategoryStatus : PurchaseOrgCategoryStatus.values()) {
            if (!orgMap.containsKey(orgCategoryStatus.getValue())) continue;
            TreeOrgNode categoryTree = new TreeOrgNode();
            categoryTree.setValue(orgCategoryStatus.getValue());
            categoryTree.setTitle(orgCategoryStatus.getDesc());
            categoryTree.setChildren(orgMap.get(orgCategoryStatus.getValue()));
            categoryList.add(categoryTree);
        }
        return categoryList;
    }

    private void deleteRedis(String table) {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append(table);
        this.redisUtil.deleteByPrex(redisKey.toString());
    }
}

