/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseOrganizationInfoExcelHandler")
public class PurchaseOrganizationInfoExcelHandler
implements ExcelImportRpcService {
    @Autowired
    InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    public void importExcel(List<Map<String, Object>> dataList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("org");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7ec4\u7ec7\u67b6\u6784\u4e1a\u52a1\u6a21\u677f\u3002");
        ArrayList<PurchaseOrganizationInfo> entityList = new ArrayList<PurchaseOrganizationInfo>();
        for (Map<String, Object> data : dataList) {
            PurchaseOrganizationInfo entity = (PurchaseOrganizationInfo)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseOrganizationInfo.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setId(IdWorker.getIdStr());
            entityList.add(entity);
        }
        List superBusinessList = entityList.stream().map(PurchaseOrganizationInfo::getSuperBusinessId).filter(x -> StrUtil.isNotEmpty((CharSequence)x) && x.split(",").length == 1).distinct().collect(Collectors.toList());
        List<String> superExecutiveList = entityList.stream().map(PurchaseOrganizationInfo::getSuperExecutiveId).filter(x -> StrUtil.isNotEmpty((CharSequence)x) && x.split(",").length == 1).distinct().collect(Collectors.toList());
        superBusinessList.addAll(superExecutiveList);
        Map<String, String> newIdsMap = entityList.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getOrgCategoryCode()) && StrUtil.isNotEmpty((CharSequence)x.getOrgCode())).collect(Collectors.toMap(x -> x.getOrgCategoryCode() + "," + x.getOrgCode(), BaseEntity::getId, (v1, v2) -> v2));
        Map<String, String> idsMap = this.purchaseOrganizationInfoService.mapIdsByOrgCodeAndOrgCategoryCode(superExecutiveList);
        for (PurchaseOrganizationInfo info : entityList) {
            String supperId;
            if (StrUtil.isEmpty((CharSequence)info.getSuperBusinessId())) {
                info.setSuperBusinessId(null);
            } else {
                supperId = idsMap.get(info.getSuperBusinessId());
                if (null == supperId) {
                    supperId = newIdsMap.get(info.getSuperBusinessId());
                }
                info.setSuperBusinessId(supperId);
            }
            if (StrUtil.isEmpty((CharSequence)info.getSuperExecutiveId())) {
                info.setSuperExecutiveId(null);
                continue;
            }
            supperId = idsMap.get(info.getSuperExecutiveId());
            if (null == supperId) {
                supperId = newIdsMap.get(info.getSuperExecutiveId());
            }
            info.setSuperExecutiveId(supperId);
        }
        this.purchaseOrganizationInfoService.saveBatch(entityList);
    }
}

