/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceAdapter
implements AuditOptCallBackService {
    @Resource
    PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseMaterialSource source = new PurchaseMaterialSource();
        source.setId(inputParamVO.getBusinessId());
        source.setAuditStatus(outputParamVO.getAuditStatus());
        source.setFlowId(outputParamVO.getProcessRootId());
        source.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
        this.purchaseMaterialSourceMapper.updateById((Object)source);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
    }

    private void updateSource(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseMaterialSource source = new PurchaseMaterialSource();
        source.setId(inputParamVO.getBusinessId());
        source.setAuditStatus(outputParamVO.getAuditStatus());
        source.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseMaterialSourceMapper.updateById((Object)source);
    }
}

