/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurchaseInformationRecordsAdapter
implements AuditOptCallBackService {
    @Autowired
    PurchaseInformationRecordsService purchaseInformationRecordsService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)JSON.parseObject((String)params, PurchaseInformationRecords.class));
        this.purchaseInformationRecordsService.updatePurchaseInformationRecords(records);
        this.updateRecord(inputParamVO, outputParamVO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)this.purchaseInformationRecordsService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        records.setId(inputParamVO.getBusinessId());
        records.setAuditStatus(outputParamVO.getAuditStatus());
        records.setFlowId(outputParamVO.getProcessRootId());
        records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
        this.purchaseInformationRecordsService.cutOffPriceDate(records);
        this.purchaseInformationRecordsService.updateById((Object)records);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateRecord(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateRecord(inputParamVO, outputParamVO);
    }

    private void updateRecord(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseInformationRecords records = new PurchaseInformationRecords();
        records.setId(inputParamVO.getBusinessId());
        records.setAuditStatus(outputParamVO.getAuditStatus());
        records.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseInformationRecordsService.updateById((Object)records);
    }
}

