/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialSourceExcelHandler")
public class PurchaseMaterialSourceExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void importExcel(List<Map<String, Object>> dataList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("materialSource");
        ArrayList<PurchaseMaterialSource> entityList = new ArrayList<PurchaseMaterialSource>();
        for (Map<String, Object> data : dataList) {
            PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseMaterialSource.class));
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion().toString());
            entity.setElsAccount(TenantContext.getTenant());
            entity.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)entity));
            entityList.add(entity);
        }
        this.purchaseMaterialSourceService.saveBatch(entityList);
    }
}

