/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseBomItemImportImpl")
public class PurchaseBomItemImportImpl
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBomItemImportImpl.class);
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Autowired
    private PurchaseBomItemService purchaseBomItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    private String headId;

    public TemplateHeadDTO getTemplate(String headId) {
        this.headId = headId;
        PurchaseBomHead dbHead = (PurchaseBomHead)((Object)this.purchaseBomHeadService.getById((Serializable)((Object)headId)));
        String account = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
        String templateVersion = String.valueOf(dbHead.getTemplateVersion());
        return this.invokeBaseRpcService.getTemplateConfig(account, dbHead.getTemplateNumber(), templateVersion);
    }

    public List<Object> getExportData(String headId) {
        List<PurchaseBomItem> itemList = this.purchaseBomItemService.selectByMainId(headId);
        return Lists.newArrayList(itemList);
    }

    public void importExcel(List<Map<String, Object>> dataList) {
        List configItemList = this.getTemplate(this.headId).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber"};
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        editColumn.addAll(Arrays.asList(excludeColumn));
        ArrayList mastrialNumbers = Lists.newArrayList();
        for (Map<String, Object> data : dataList) {
            for (String string : data.keySet()) {
                if (editColumn.contains(string)) continue;
                data.put(string, null);
            }
            String materialNumber = (String)data.get("materialNumber");
            if (!CharSequenceUtil.isNotEmpty((CharSequence)materialNumber)) continue;
            mastrialNumbers.add(materialNumber);
        }
        List<PurchaseMaterialHead> masterialList = this.purchaseMaterialHeadService.getMaterialHeadByNumbers(mastrialNumbers);
        Map materialHeadMap = masterialList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
        for (Map map : dataList) {
            Field[] fields;
            String materialNumber = (String)map.get("materialNumber");
            if (!CharSequenceUtil.isNotEmpty((CharSequence)materialNumber)) continue;
            PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)materialHeadMap.get(materialNumber));
            Assert.notNull((Object)((Object)head), (String)I18nUtil.translate((String)"i18n_alert_SLAoWWxMK_c3a38ed4", (String)"\u7269\u6599\u7f16\u7801${0}\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber}));
            for (Field field : fields = ConvertUtils.getAllFields((Object)((Object)head))) {
                if (!map.containsKey(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    map.put(field.getName(), field.get((Object)head));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }
}

