/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.enumerate.MaterialSourceTypeEnum;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.MaterialCreateSourceTypeEnum;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.price.mapper.PurchaseInformationRecordsMapper;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.vo.HisQuotePriceTrendVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseInformationRecordsServiceImpl
extends ServiceImpl<PurchaseInformationRecordsMapper, PurchaseInformationRecords>
implements PurchaseInformationRecordsService {
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;

    @Override
    public void savePurchaseInformationRecords(PurchaseInformationRecords records) {
        if (StringUtils.isBlank((CharSequence)records.getInfoRecordNumber())) {
            records.setInfoRecordNumber(this.baseRpcService.getNextCode("srmPriceNumber", (Object)records));
        }
        records.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        if (StrUtil.isEmpty((CharSequence)records.getAuditStatus())) {
            records.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            records.setRecordStatus(PriceStatusEnum.NEW.getValue());
        }
        if (StrUtil.isEmpty((CharSequence)records.getRecordStatus())) {
            records.setRecordStatus(PriceStatusEnum.NEW.getValue());
        }
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(records.getAuditStatus())) {
            records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
            this.checkStatus(records);
        }
        records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
        if (null != records.getExpiryDate() && null != records.getEffectiveDate() && records.getExpiryDate().before(records.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        ((PurchaseInformationRecordsMapper)this.baseMapper).insert((Object)records);
    }

    @Override
    public void calculatePrice(PurchaseInformationRecords records) {
        BigDecimal taxRate = StrUtil.isBlank((CharSequence)records.getTaxRate()) ? BigDecimal.ZERO : new BigDecimal(records.getTaxRate()).divide(BigDecimal.valueOf(100L));
        BigDecimal price = records.getPrice() == null ? BigDecimal.ZERO : records.getPrice();
        BigDecimal freight = records.getFreight() == null ? BigDecimal.ZERO : records.getFreight();
        BigDecimal discount = records.getDiscount() == null ? BigDecimal.ZERO : records.getDiscount();
        BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        BigDecimal theNetPrice = price.add(freight).subtract(discount);
        records.setNetPrice(netPrice);
        records.setTheNetPrice(theNetPrice);
    }

    @Override
    public String createMaterialSource(List<PurchaseInformationRecords> recordsList) {
        System.out.println(recordsList.toString());
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(recordsList), (String)I18nUtil.translate((String)"i18n_alert_ViFTPsSjumdWFc_6498c6ee", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u8f6c\u6362\u7684\u4ef7\u683c\u4e3b\u6570\u636e\u884c"));
        ArrayList<PurchaseMaterialSource> sourceList = new ArrayList<PurchaseMaterialSource>();
        for (int index = 0; index < recordsList.size(); ++index) {
            PurchaseInformationRecords records = recordsList.get(index);
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialSource::getSourceId});
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getMaterialNumber, (Object)records.getMaterialNumber());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getFactory, (Object)records.getFactory());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getCompany, (Object)records.getCompany());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getPurchaseOrg, (Object)records.getPurchaseOrg());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getToElsAccount, (Object)records.getToElsAccount());
            List list = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
            if (list.size() <= 0) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dicumtHyWWWWWWWIsSjVtWWWWWW_cdd6e7c8", (String)"\u6240\u9009\u884c\u4ef7\u683c\u8bb0\u5f55\u53f7: ${0} \u5df2\u8f6c\u8d27\u6e90\u6e05\u5355: ${1}", (String[])new String[]{records.getInfoRecordNumber(), ((PurchaseMaterialSource)((Object)list.get(0))).getSourceId()}));
        }
        for (PurchaseInformationRecords records : recordsList) {
            PurchaseMaterialSource source = new PurchaseMaterialSource();
            BeanUtils.copyProperties((Object)((Object)records), (Object)((Object)source));
            source.setToElsDesc(records.getSupplierName());
            source.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)source));
            source.setId(null);
            source.setMaterialSourceType(MaterialSourceTypeEnum.MATERIAL.getValue());
            source.setCreateTime(new Date());
            source.setUpdateTime(new Date());
            source.setFlowId(null);
            source.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            source.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
            source.setSourceType(MaterialCreateSourceTypeEnum.PRICE.getValue());
            sourceList.add(source);
        }
        this.purchaseMaterialSourceService.addBatch(sourceList);
        return sourceList.stream().map(PurchaseMaterialSource::getSourceId).collect(Collectors.toList()).toString();
    }

    @Override
    public void addBatch(List<PurchaseInformationRecords> recordsList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        if (CollectionUtil.isNotEmpty(recordsList) && CollectionUtil.isNotEmpty((Collection)templateList)) {
            PurchaseInformationRecords entity = recordsList.get(0);
            long size = recordsList.stream().filter(x -> StrUtil.isBlank((CharSequence)x.getInfoRecordNumber())).count();
            List nextCodes = this.baseRpcService.getNextCodes("srmPriceNumber", (Object)entity, (int)size);
            int codeIndex = 0;
            for (PurchaseInformationRecords records : recordsList) {
                records.setId(null);
                if (StringUtils.isBlank((CharSequence)records.getInfoRecordNumber())) {
                    records.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
                }
                records.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                records.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                records.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                records.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
                records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
                this.cutOffPriceDate(records);
                records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                this.checkStatus(records);
            }
            this.saveBatch(recordsList);
        }
    }

    @Override
    public void updatePurchaseInformationRecords(PurchaseInformationRecords purchaseInformationRecords) {
        if (null != purchaseInformationRecords.getPrice() && purchaseInformationRecords.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_xfuxOXUEUWW_3bbae979", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01"));
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getPriceType()), (String)I18nUtil.translate((String)"i18n_alert_umAclS_b641dd5b", (String)"\u4ef7\u683c\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLKWSLAylS_a87995e2", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u7269\u6599\u7f16\u53f7\u5fc5\u586b"));
        } else if ("2".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLVKWSLVlS_dce240f5", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        Assert.isTrue((StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getFactory()) || StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getPurchaseOrg()) ? 1 : 0) != 0, (String)"\u5de5\u5382\u548c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a");
        purchaseInformationRecords.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseInformationRecords.getAuditStatus())) {
            this.cutOffPriceDate(purchaseInformationRecords);
            this.checkStatus(purchaseInformationRecords);
        }
        if (null != purchaseInformationRecords.getExpiryDate() && null != purchaseInformationRecords.getEffectiveDate() && purchaseInformationRecords.getExpiryDate().before(purchaseInformationRecords.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        this.calculatePrice(purchaseInformationRecords);
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)purchaseInformationRecords);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cutOffPriceDate(PurchaseInformationRecords records) {
        LambdaQueryWrapper countWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)countWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)records.getToElsAccount())).eq(PurchaseInformationRecords::getPriceType, (Object)records.getPriceType());
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)records.getToElsAccount())).eq(PurchaseInformationRecords::getPriceType, (Object)records.getPriceType());
        if (PurchaseInformationPriceTypeEnum.MATERIAL.getValue().equals(records.getPriceType())) {
            countWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)records.getMaterialNumber());
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)records.getMaterialNumber());
        } else if (PurchaseInformationPriceTypeEnum.MATERIAL_GROUP.getValue().equals(records.getPriceType())) {
            countWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)records.getMaterialGroup());
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)records.getMaterialGroup());
        } else {
            String msg = CharSequenceUtil.isEmpty((CharSequence)records.getId()) ? "" : "[ " + records.getId() + " ]";
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFWWWWWWWWumAcLV_910b114f", (String)"\u4ef7\u683c\u4e3b\u6570\u636e${0}\u4ef7\u683c\u7c7b\u578b\u4e3a\u7a7a", (String[])new String[]{msg}));
        }
        if (StringUtils.isNotBlank((CharSequence)records.getFactory())) {
            countWrapper.eq(PurchaseInformationRecords::getFactory, (Object)records.getFactory());
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)records.getFactory());
        } else {
            countWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)records.getPurchaseOrg());
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)records.getPurchaseOrg());
        }
        ArrayList recordStatusList = Lists.newArrayList((Object[])new String[]{PriceStatusEnum.NORMAL.getValue(), PriceStatusEnum.FROZEN.getValue(), PriceStatusEnum.EFFECTIVE.getValue()});
        ArrayList auditStatusList = Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()});
        ((LambdaQueryWrapper)countWrapper.in(PurchaseInformationRecords::getAuditStatus, (Collection)auditStatusList)).in(PurchaseInformationRecords::getRecordStatus, (Collection)recordStatusList);
        ((LambdaQueryWrapper)queryWrapper.in(PurchaseInformationRecords::getAuditStatus, (Collection)auditStatusList)).in(PurchaseInformationRecords::getRecordStatus, (Collection)recordStatusList);
        countWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.or(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.le(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).le(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate());
            });
        });
        countWrapper.ne(CharSequenceUtil.isNotBlank((CharSequence)records.getId()), BaseEntity::getId, (Object)records.getId());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).selectCount((Wrapper)countWrapper);
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umdWFjXAKBAVsW_7e63ed0d", (String)"\u4ef7\u683c\u4e3b\u6570\u636e\u6709\u6548\u8d77\u59cb\u65e5\u671f\u91cd\u53e0!"));
        queryWrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).lt(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate())).gt(PurchaseInformationRecords::getExpiryDate, (Object)records.getEffectiveDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.gt(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).gt(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate())).lt(PurchaseInformationRecords::getEffectiveDate, (Object)records.getExpiryDate());
            });
        });
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseInformationRecords::getEffectiveDate, PurchaseInformationRecords::getExpiryDate});
        List disRecords = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        Assert.isTrue((disRecords.size() <= 2 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umdWFOTjXAKBAVsW_ecc56066", (String)"\u4ef7\u683c\u4e3b\u6570\u636e\u591a\u6761\u6709\u6548\u8d77\u59cb\u65e5\u671f\u91cd\u53e0!"));
        if (disRecords.isEmpty()) {
            return;
        }
        int maxStartTime = 0;
        for (PurchaseInformationRecords disRecord : disRecords) {
            Calendar calendar = Calendar.getInstance();
            if (disRecord.getEffectiveDate().after(records.getEffectiveDate()) && disRecord.getExpiryDate().after(records.getExpiryDate())) {
                calendar.setTime(records.getExpiryDate());
                calendar.add(5, 1);
                disRecord.setEffectiveDate(calendar.getTime());
                ++maxStartTime;
                continue;
            }
            if (disRecord.getEffectiveDate().before(records.getEffectiveDate()) && disRecord.getExpiryDate().before(records.getExpiryDate())) {
                calendar.setTime(records.getEffectiveDate());
                calendar.add(5, -1);
                disRecord.setExpiryDate(calendar.getTime());
                continue;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFjXAKBAVsW_7e63ed0d", (String)"\u4ef7\u683c\u4e3b\u6570\u636e\u6709\u6548\u8d77\u59cb\u65e5\u671f\u91cd\u53e0!"));
        }
        if (disRecords.size() == 2 && maxStartTime != 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFjXAKBAVsW_7e63ed0d", (String)"\u4ef7\u683c\u4e3b\u6570\u636e\u6709\u6548\u8d77\u59cb\u65e5\u671f\u91cd\u53e0!"));
        }
        for (PurchaseInformationRecords disRecord : disRecords) {
            disRecord.setUpdateTime(new Date());
            disRecord.setUpdateBy(TenantContext.getTenant());
            ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)disRecord);
        }
    }

    @Override
    public void frozenPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.FROZEN.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void checkStatus(PurchaseInformationRecords record) {
        DateTime date = DateUtil.date();
        if (null != record.getEffectiveDate() && record.getEffectiveDate().before((Date)date)) {
            record.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
        }
        if (null != record.getExpiryDate() && record.getExpiryDate().before((Date)date)) {
            record.setRecordStatus(PriceStatusEnum.INVALID.getValue());
        }
    }

    @Override
    public void thawPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
        this.checkStatus(record);
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelBySourceNumber(String sourceType, String sourceNumber, List<String> itemNumberList) {
        String elsAccount = TenantContext.getTenant();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseInformationRecords::getSourceNumber, (Object)sourceNumber)).eq(PurchaseInformationRecords::getSourceType, (Object)sourceType)).in(PurchaseInformationRecords::getSourceItemNumber, itemNumberList);
        PurchaseInformationRecords records = new PurchaseInformationRecords();
        records.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).update((Object)records, (Wrapper)updateWrapper);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delPurchaseInformationRecords(String id) {
        ((PurchaseInformationRecordsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseInformationRecords(List<String> idList) {
        ((PurchaseInformationRecordsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public HisQuotePriceTrendVO findTrendByMaterial(String materialNumber) {
        LambdaQueryWrapper itemQueryWrapper = new LambdaQueryWrapper();
        itemQueryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)materialNumber);
        itemQueryWrapper.orderByAsc(PurchaseInformationRecords::getQuoteDate);
        List itemList = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)itemQueryWrapper);
        HisQuotePriceTrendVO trendVO = new HisQuotePriceTrendVO();
        Map<String, List<PurchaseInformationRecords>> itemMap = itemList.parallelStream().filter(item -> item.getQuoteDate() != null).collect(Collectors.groupingBy(item -> DateUtil.format((Date)item.getQuoteDate(), (String)"yyyy-MM-dd")));
        List<String> xAxisData = itemList.parallelStream().map(item -> DateUtil.format((Date)item.getQuoteDate(), (String)"yyyy-MM-dd")).distinct().collect(Collectors.toList());
        ArrayList<BigDecimal> seriesData = new ArrayList<BigDecimal>();
        for (String quoteDate : xAxisData) {
            List<PurchaseInformationRecords> masterList = itemMap.get(quoteDate);
            if (masterList.size() > 1) {
                BigDecimal minPrice = masterList.parallelStream().filter(x -> x.getPrice() != null).map(PurchaseInformationRecords::getPrice).min(BigDecimal::compareTo).get();
                seriesData.add(minPrice);
                continue;
            }
            PurchaseInformationRecords records = masterList.get(0);
            seriesData.add((BigDecimal)ObjectUtil.defaultIfNull((Object)records.getPrice(), (Object)BigDecimal.ZERO));
        }
        trendVO.setXAxisData(xAxisData);
        trendVO.setSeriesData(seriesData);
        return trendVO;
    }

    @Override
    public PurchaseInformationRecords getEffectiveRecord(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String priceType = StringUtils.isNotBlank((CharSequence)materialNumber) ? "1" : "2";
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)toElsAccount)).eq(PurchaseInformationRecords::getPriceType, (Object)priceType);
        if (StringUtils.isNotBlank((CharSequence)materialNumber)) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)materialNumber);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)materialGroup);
        }
        if (StringUtils.isNotBlank((CharSequence)factory)) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)factory);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseOrg);
        }
        queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getEffectiveDate, (Object)new Date())).gt(PurchaseInformationRecords::getExpiryDate, (Object)new Date());
        });
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return record;
    }

    @Override
    public List<PurchaseInformationRecords> getEffectiveRecordList(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)materialNumber) && StringUtils.isBlank((CharSequence)materialGroup)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLSSLVRRTPjIm_f8fc5a66", (String)"\u7269\u6599\u6216\u7269\u6599\u7ec4\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a"));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String priceType = StringUtils.isNotBlank((CharSequence)materialNumber) ? "1" : "2";
        queryWrapper.eq(PurchaseInformationRecords::getPriceType, (Object)priceType);
        if (StringUtils.isNotBlank((CharSequence)toElsAccount)) {
            queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)toElsAccount);
        }
        if (StringUtils.isNotBlank((CharSequence)materialNumber)) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)materialNumber);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)materialGroup);
        }
        if (StringUtils.isNotBlank((CharSequence)factory)) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)factory);
        } else if (StringUtils.isNotBlank((CharSequence)purchaseOrg)) {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseOrg);
        }
        queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getEffectiveDate, (Object)new Date())).gt(PurchaseInformationRecords::getExpiryDate, (Object)new Date());
        });
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void insertInfomationRecordsBatch(ArrayList<PurchaseInformationRecords> copyProperties) {
        this.saveBatch(copyProperties);
    }

    @Override
    public boolean checkPriceIfCreateByType(PurchaseInformationRecords records) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseInformationRecords::getSourceNumber, (Object)records.getSourceNumber())).eq(PurchaseInformationRecords::getSourceItemNumber, (Object)records.getSourceItemNumber())).eq(PurchaseInformationRecords::getAuditStatus, (Object)records.getAuditStatus())).eq(PurchaseInformationRecords::getPriceType, (Object)records.getPriceType())).eq(PurchaseInformationRecords::getSourceType, (Object)records.getSourceType());
        return ((PurchaseInformationRecordsMapper)this.baseMapper).selectCount((Wrapper)wrapper) > 0;
    }

    @Override
    public List<String> checkPriceForSome(List<String> stringList) {
        List<PurchaseInformationRecords> purchaseInformationRecords = ((PurchaseInformationRecordsMapper)this.baseMapper).checkPriceForSome(stringList);
        return purchaseInformationRecords.parallelStream().map(o -> o.getMaterialNumber() + "_" + o.getFactory() + "_" + o.getPurchaseOrg()).distinct().collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePriceStatusForJob() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DateTime date = DateUtil.date();
        param.put("nowDate", date);
        List<PurchaseInformationRecords> records = ((PurchaseInformationRecordsMapper)this.baseMapper).selectWithoutElsAccountToChangeStatus(param);
        for (PurchaseInformationRecords item : records) {
            if (null != item.getEffectiveDate() && item.getEffectiveDate().before((Date)date)) {
                item.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
            }
            if (null == item.getExpiryDate() || !item.getExpiryDate().before((Date)date)) continue;
            item.setRecordStatus(PriceStatusEnum.INVALID.getValue());
        }
        this.updateBatchById(records);
    }
}

