/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.entity.SaleMaterialRelation;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialRelationService;
import com.els.modules.material.service.SaleMaterialRelationService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="saleMaterialRelationImportImpl")
public class SaleMaterialRelationImportImpl
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired
    private PurchaseMaterialRelationService purchaseMaterialRelationService;
    @Autowired
    private SaleMaterialRelationService saleMaterialRelationService;

    public void importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        ArrayList<SaleMaterialRelation> list = new ArrayList<SaleMaterialRelation>();
        Date currentTime = new Date();
        ArrayList elsToElsAccountList = Lists.newArrayList();
        for (Map<String, Object> data : dataList) {
            SaleMaterialRelation materialRelation = (SaleMaterialRelation)((Object)JSON.parseObject((String)JSON.toJSONString(data), SaleMaterialRelation.class));
            elsToElsAccountList.add(materialRelation.getToElsAccount() + "_" + materialRelation.getElsAccount());
            list.add(materialRelation);
        }
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.listByElsAndToElsAccount((List)elsToElsAccountList);
        Map supplierMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v1));
        HashMap materialMap = Maps.newHashMap();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        for (SaleMaterialRelation materialRelation : list) {
            PurchaseMaterialHead materialHead;
            materialRelation.setId(IdWorker.getIdStr());
            materialRelation.setRelationId(IdWorker.getIdStr());
            materialRelation.setElsAccount(elsAccount);
            materialRelation.setCreateAccount(elsAccount);
            materialRelation.setDeleted(CommonConstant.DEL_FLAG_0);
            materialRelation.setCreateTime(currentTime);
            if (StrUtil.isBlank((CharSequence)materialRelation.getBlocked())) {
                materialRelation.setBlocked("0");
            }
            materialRelation.setCreateBy(SysUtil.getUserRealName());
            materialRelation.setUpdateTime(currentTime);
            materialRelation.setUpdateBy(materialRelation.getCreateBy());
            String toElsAccount = materialRelation.getToElsAccount();
            SupplierMasterDataDTO masterData = (SupplierMasterDataDTO)supplierMap.get(toElsAccount);
            if (null == masterData) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXWWWeyWWWWWWxMKWVnIWFW_77bcc1ac", (String)("\u4f9b\u5e94\u5546ELS\u8d26\u53f7\uff1a" + toElsAccount + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01"), (String[])new String[]{toElsAccount}));
            }
            materialRelation.setSupplierCode(masterData.getSupplierCode());
            materialRelation.setSupplierName(masterData.getSupplierName());
            String materialNumber = materialRelation.getMaterialNumber();
            if (materialMap.containsKey(materialNumber)) {
                materialHead = (PurchaseMaterialHead)((Object)materialMap.get(materialNumber));
            } else {
                TenantContext.setTenant((String)toElsAccount);
                List materialList = this.purchaseMaterialHeadService.list((Wrapper)new QueryWrapper().eq((Object)"material_number", (Object)materialNumber));
                if (materialList.isEmpty()) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoWWxMK_c3a38ed4", (String)"\u7269\u6599\u7f16\u7801${0}\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber}));
                }
                materialHead = (PurchaseMaterialHead)((Object)materialList.get(0));
                materialMap.put(materialNumber, materialHead);
                materialNumberList.add(materialNumber);
            }
            materialRelation.setMaterialDesc(materialHead.getMaterialDesc());
            materialRelation.setMaterialSpec(materialHead.getMaterialSpec());
        }
        TenantContext.setTenant((String)elsAccount);
        ArrayList toElsAccountList = Lists.newArrayList(supplierMap.keySet());
        List materialRelationList = this.saleMaterialRelationService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"to_els_account", (Collection)toElsAccountList)).in((Object)"material_number", materialNumberList));
        HashMap<String, SaleMaterialRelation> relationMap = new HashMap<String, SaleMaterialRelation>();
        for (SaleMaterialRelation relation : materialRelationList) {
            relationMap.put(relation.getToElsAccount() + relation.getMaterialNumber(), relation);
        }
        ArrayList<PurchaseMaterialRelation> insertList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> insertSaleList = new ArrayList<SaleMaterialRelation>();
        ArrayList<PurchaseMaterialRelation> updateList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> updateSaleList = new ArrayList<SaleMaterialRelation>();
        for (SaleMaterialRelation relation : list) {
            if (relationMap.containsKey(relation.getToElsAccount() + relation.getMaterialNumber())) {
                SaleMaterialRelation materialRelation = (SaleMaterialRelation)((Object)relationMap.get(relation.getToElsAccount() + relation.getMaterialNumber()));
                relation.setId(materialRelation.getId());
                relation.setRelationId(materialRelation.getRelationId());
                if (!elsAccount.equals(materialRelation.getCreateAccount())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRCWWWeyWWWWWWWWnRCSLAyWWWWWWjtHnRCIOcIWxqKmcIW_6e9f438d", (String)("\u91c7\u8d2d\u65b9ELS\u8d26\u53f7\uff1a" + materialRelation.getToElsAccount() + " , \u91c7\u8d2d\u65b9\u7269\u6599\u7f16\u53f7\uff1a" + materialRelation.getMaterialNumber() + " \u7684\u8bb0\u5f55\u91c7\u8d2d\u65b9\u5df2\u7ecf\u521b\u5efa\uff0c\u4e0d\u53ef\u518d\u6b21\u521b\u5efa\uff01"), (String[])new String[]{materialRelation.getToElsAccount(), materialRelation.getMaterialNumber()}));
                }
                updateSaleList.add(relation);
                PurchaseMaterialRelation purcahseMaterialRelation = new PurchaseMaterialRelation();
                BeanUtils.copyProperties((Object)((Object)relation), (Object)((Object)purcahseMaterialRelation));
                purcahseMaterialRelation.setId(relation.getRelationId());
                purcahseMaterialRelation.setRelationId(relation.getId());
                purcahseMaterialRelation.setElsAccount(relation.getToElsAccount());
                purcahseMaterialRelation.setToElsAccount(relation.getElsAccount());
                updateList.add(purcahseMaterialRelation);
                continue;
            }
            insertSaleList.add(relation);
            PurchaseMaterialRelation purcahseMaterialRelation = new PurchaseMaterialRelation();
            BeanUtils.copyProperties((Object)((Object)relation), (Object)((Object)purcahseMaterialRelation));
            purcahseMaterialRelation.setId(relation.getRelationId());
            purcahseMaterialRelation.setRelationId(relation.getId());
            purcahseMaterialRelation.setElsAccount(relation.getToElsAccount());
            purcahseMaterialRelation.setToElsAccount(relation.getElsAccount());
            insertList.add(purcahseMaterialRelation);
        }
        if (!insertList.isEmpty()) {
            this.purchaseMaterialRelationService.saveBatch(insertList, 2000);
            this.saleMaterialRelationService.saveBatch(insertSaleList, 2000);
        }
        if (!updateList.isEmpty()) {
            this.purchaseMaterialRelationService.updateBatchById(updateList, 2000);
            this.saleMaterialRelationService.updateBatchById(updateSaleList, 2000);
        }
    }
}

