/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PurchaseInformationRecordsAdapter
implements AuditOptCallBackService {
    @Autowired
    PurchaseInformationRecordsService purchaseInformationRecordsService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)JSON.parseObject((String)params, PurchaseInformationRecords.class));
        this.purchaseInformationRecordsService.updatePurchaseInformationRecords(records);
        this.updateRecord(inputParamVO, outputParamVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)this.purchaseInformationRecordsService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        records.setId(inputParamVO.getBusinessId());
        records.setAuditStatus(outputParamVO.getAuditStatus());
        records.setFlowId(outputParamVO.getProcessRootId());
        records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
        this.purchaseInformationRecordsService.cutOffPriceDate(records);
        this.purchaseInformationRecordsService.checkStatus(records);
        boolean count = this.purchaseInformationRecordsService.updateById((Object)records);
        if (!count) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateRecord(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateRecord(inputParamVO, outputParamVO);
    }

    private void updateRecord(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseInformationRecords records = new PurchaseInformationRecords();
        records.setId(inputParamVO.getBusinessId());
        records.setAuditStatus(outputParamVO.getAuditStatus());
        records.setFlowId(outputParamVO.getProcessRootId());
        boolean count = this.purchaseInformationRecordsService.updateById((Object)records);
        if (!count) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

