/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.vo.PurchaseBomHeadVO;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBomAdapter
implements AuditOptCallBackService {
    @Autowired
    PurchaseBomHeadService purchaseBomHeadService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchaseBomHeadVO headVO = (PurchaseBomHeadVO)((Object)JSON.parseObject((String)params, PurchaseBomHeadVO.class));
        this.checkParams(headVO);
        PurchaseBomHead purchaseBomHead = new PurchaseBomHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseBomHead));
        purchaseBomHead.setBomStatus(PurchaseBomStatus.NEW.getValue());
        this.purchaseBomHeadService.updateMain(headVO, headVO.getPurchaseBomItemList());
        this.updateBom(inputParamVO, outputParamVO);
    }

    private void checkParams(PurchaseBomHeadVO headVO) {
        Assert.hasText((String)headVO.getMaterialNumber(), (String)"\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801");
        Assert.hasText((String)headVO.getBomPurpose(), (String)"\u8bf7\u586b\u5199BOM\u7528\u9014");
        Assert.hasText((String)headVO.getVersion(), (String)"\u8bf7\u586b\u5199\u7248\u672c");
        Assert.notNull((Object)headVO.getEffectiveDate(), (String)"\u8bf7\u586b\u5199\u751f\u6548\u65e5\u671f");
        Assert.notNull((Object)headVO.getExpiryDate(), (String)"\u8bf7\u586b\u5199\u5931\u6548\u65e5\u671f");
        List<PurchaseBomItem> itemList = headVO.getPurchaseBomItemList();
        for (PurchaseBomItem item : itemList) {
            Assert.hasText((String)item.getBomLevel(), (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1aBOM\u5c42\u7ea7");
            Assert.hasText((String)item.getMaterialNumber(), (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1a\u7269\u6599\u7f16\u7801");
            Assert.hasText((String)item.getVirtualMaterial(), (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1a\u865a\u62df\u7269\u6599");
            Assert.hasText((String)item.getMaterialOrder(), (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1a\u6392\u5e8f");
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBomHead bomHead = new PurchaseBomHead();
        bomHead.setId(inputParamVO.getBusinessId());
        bomHead.setBomStatus(PurchaseBomStatus.NORMAL.getValue());
        bomHead.setAuditStatus(outputParamVO.getAuditStatus());
        bomHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseBomHeadService.updateById((Object)bomHead);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateBom(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateBom(inputParamVO, outputParamVO);
    }

    private void updateBom(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBomHead bomHead = new PurchaseBomHead();
        bomHead.setId(inputParamVO.getBusinessId());
        bomHead.setAuditStatus(outputParamVO.getAuditStatus());
        bomHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseBomHeadService.updateById((Object)bomHead);
    }
}

