/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.industryinfo.dto.ElsGoodsInformationQueryDTO;
import com.els.modules.industryinfo.entity.ElsGoodsInformation;
import com.els.modules.industryinfo.mapper.ElsGoodsInformationMapper;
import com.els.modules.industryinfo.service.ElsGoodsInformationService;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ElsGoodsInformationServiceImpl
extends BaseServiceImpl<ElsGoodsInformationMapper, ElsGoodsInformation>
implements ElsGoodsInformationService {
    @Override
    public IPage<ElsGoodsInformation> queryPage(Page<ElsGoodsInformation> page, QueryWrapper<ElsGoodsInformation> queryWrapper, ElsGoodsInformationQueryDTO queryDTO) {
        String timeSelect;
        String otherScreening;
        String goodsPrice;
        String goodsRatio = queryDTO.getGoodsCommissionRatio();
        if (StringUtils.isNotBlank((CharSequence)goodsRatio) && goodsRatio.contains("-")) {
            String[] ratio = goodsRatio.split("-");
            queryWrapper.lambda().between(ElsGoodsInformation::getCommissionRatio, (Object)new BigDecimal(ratio[0]), (Object)new BigDecimal(ratio[1]));
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsPrice = queryDTO.getGoodsPrice()))) {
            String price;
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.lambda().between(ElsGoodsInformation::getPrice, (Object)new BigDecimal(prices[0]), (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                price = goodsPrice.substring(goodsPrice.indexOf("<") + 1);
                queryWrapper.lambda().lt(ElsGoodsInformation::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                price = goodsPrice.substring(goodsPrice.indexOf(">") + 1);
                queryWrapper.lambda().gt(ElsGoodsInformation::getPrice, (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(otherScreening = queryDTO.getOtherScreening()))) {
            if ("1".equals(otherScreening)) {
                queryWrapper.lambda().isNotNull(ElsGoodsInformation::getLiveGoods);
            } else if ("2".equals(otherScreening)) {
                queryWrapper.lambda().isNotNull(ElsGoodsInformation::getVideoGoods);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(timeSelect = queryDTO.getTimeSelect()))) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getUpdateTime, (Object)selectDay, (Object)today);
        }
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void saveElsGoodsInformation(ElsGoodsInformation elsGoodsInformation) {
        ((ElsGoodsInformationMapper)this.baseMapper).insert((Object)elsGoodsInformation);
    }

    @Override
    public void updateElsGoodsInformation(ElsGoodsInformation elsGoodsInformation) {
        ((ElsGoodsInformationMapper)this.baseMapper).updateById((Object)elsGoodsInformation);
    }
}

