/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsLiveItem;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsVideoItem;
import com.els.modules.industryinfo.mapper.GoodsHeadMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveItemMapper;
import com.els.modules.industryinfo.mapper.GoodsTopmanItemMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoItemMapper;
import com.els.modules.industryinfo.service.GoodsHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsHeadServiceImpl
extends BaseServiceImpl<GoodsHeadMapper, GoodsHead>
implements GoodsHeadService {
    @Autowired
    private GoodsHeadMapper goodsHeadMapper;
    @Autowired
    private GoodsTopmanItemMapper goodsTopmanItemMapper;
    @Autowired
    private GoodsVideoItemMapper goodsVideoItemMapper;
    @Autowired
    private GoodsLiveItemMapper goodsLiveItemMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(GoodsHead goodsHead, List<GoodsTopmanItem> goodsTopmanItemList, List<GoodsVideoItem> goodsVideoItemList, List<GoodsLiveItem> goodsLiveItemList) {
        this.goodsHeadMapper.insert((Object)goodsHead);
        super.setHeadDefaultValue((BaseEntity)goodsHead);
        this.insertData(goodsHead, goodsTopmanItemList, goodsVideoItemList, goodsLiveItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(GoodsHead goodsHead, List<GoodsTopmanItem> goodsTopmanItemList, List<GoodsVideoItem> goodsVideoItemList, List<GoodsLiveItem> goodsLiveItemList) {
        this.goodsHeadMapper.updateById((Object)goodsHead);
        this.goodsTopmanItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsVideoItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsLiveItemMapper.deleteByMainId(goodsHead.getId());
        this.insertData(goodsHead, goodsTopmanItemList, goodsVideoItemList, goodsLiveItemList);
    }

    private void insertData(GoodsHead goodsHead, List<GoodsTopmanItem> goodsTopmanItemList, List<GoodsVideoItem> goodsVideoItemList, List<GoodsLiveItem> goodsLiveItemList) {
        if (!CollectionUtils.isEmpty(goodsTopmanItemList)) {
            for (GoodsTopmanItem goodsTopmanItem : goodsTopmanItemList) {
                goodsTopmanItem.setHeadId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsTopmanItem, (BaseEntity)goodsHead);
            }
            if (!goodsTopmanItemList.isEmpty()) {
                this.goodsTopmanItemMapper.insertBatchSomeColumn(goodsTopmanItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoItemList)) {
            for (GoodsVideoItem goodsVideoItem : goodsVideoItemList) {
                goodsVideoItem.setHeadId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoItem, (BaseEntity)goodsHead);
            }
            if (!goodsVideoItemList.isEmpty()) {
                this.goodsVideoItemMapper.insertBatchSomeColumn(goodsVideoItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveItemList)) {
            for (GoodsLiveItem goodsLiveItem : goodsLiveItemList) {
                goodsLiveItem.setHeadId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveItem, (BaseEntity)goodsHead);
            }
            if (!goodsLiveItemList.isEmpty()) {
                this.goodsLiveItemMapper.insertBatchSomeColumn(goodsLiveItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.goodsTopmanItemMapper.deleteByMainId(id);
        this.goodsVideoItemMapper.deleteByMainId(id);
        this.goodsLiveItemMapper.deleteByMainId(id);
        this.goodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.goodsTopmanItemMapper.deleteByMainId(serializable.toString());
            this.goodsVideoItemMapper.deleteByMainId(serializable.toString());
            this.goodsLiveItemMapper.deleteByMainId(serializable.toString());
            this.goodsHeadMapper.deleteById(serializable);
        }
    }
}

