/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.TopManDetailBodyParam;
import com.els.modules.industryinfo.dto.TopManInformationParam;
import com.els.modules.industryinfo.entity.TopManCollectBean;
import com.els.modules.industryinfo.entity.TopManDetailHeadEntity;
import com.els.modules.industryinfo.entity.TopManGoodsListEntity;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.entity.TopManResultDetailBody;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.entity.TopManShopListEntity;
import com.els.modules.industryinfo.enumerate.MarkYn;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.excel.TopManInformationExportServiceImpl;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.els.modules.industryinfo.service.TopManInformationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/topMan"})
@Api(tags={"\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class TopManController
extends BaseController<TopManParamEntity, TopManInformationService> {
    @Autowired
    private TopManCollectService topManCollectService;
    @Autowired
    private TopManInformationService topManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list/{type}"})
    public Result<?> listAll(@RequestBody SimplePostRequestParam<TopManInformationParam> topManDto, @PathVariable(value="type") TopManQueryType topManQueryType) {
        try {
            IPage<? extends TopManResultEntity> pageList = this.topManInformationService.queryTopManList(topManDto, topManQueryType);
            return Result.ok(pageList);
        }
        catch (IllegalAccessException e) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u8f6c\u6362\u5f02\u5e38"));
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5217\u8868")
    @PostMapping(value={"/listGoods"})
    public Result<?> listGoods(@RequestBody SimplePostRequestParam<TopManDetailBodyParam> param) {
        try {
            IPage<TopManGoodsListEntity> pageList = this.topManInformationService.queryGooodsList(param);
            return Result.ok(pageList);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e97\u94fa\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u5e97\u94fa\u5217\u8868")
    @PostMapping(value={"/listShop"})
    public Result<?> listShop(@RequestBody SimplePostRequestParam<TopManDetailBodyParam> param) {
        try {
            IPage<TopManShopListEntity> pageList = this.topManInformationService.queryShopList(param);
            return Result.ok(pageList);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8fbe\u4eba\u8be6\u60c5-\u5934\u90e8\u6a21\u5757", notes="\u8fbe\u4eba\u8be6\u60c5-\u5934\u90e8\u6a21\u5757")
    @GetMapping(value={"/detail/head"})
    public Result<?> detailHead(@RequestParam(name="id") String id) {
        TopManDetailHeadEntity result = this.topManInformationService.queryDetailHead(id);
        return Result.ok((Object)((Object)result));
    }

    @ApiOperation(value="\u8fbe\u4eba\u8be6\u60c5-\u4e3b\u4f53\u6a21\u5757", notes="\u8fbe\u4eba\u8be6\u60c5-\u4e3b\u4f53\u6a21\u5757")
    @PostMapping(value={"/detail/body"})
    public Result<?> detailBody(@RequestBody SimplePostRequestParam<TopManDetailBodyParam> param) {
        TopManResultDetailBody result = this.topManInformationService.queryDetailBody(param.getFilterInfo());
        return Result.ok((Object)((Object)result));
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, final @RequestParam(value="param") String param) {
        HashMap map = new HashMap(){
            {
                this.put("ids", param.split(","));
            }
        };
        return super.exportXls(request, (Map)map, TopManInformationExportServiceImpl.class);
    }

    @GetMapping(value={"/collect"})
    @AutoLog(value="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c")
    public Result<?> collect(@RequestParam(value="yn") String yn, @RequestParam(value="platform") String platform, @RequestParam(value="topManId") String topManId) {
        if (StringUtils.isBlank((CharSequence)yn) || StringUtils.isBlank((CharSequence)platform) || StringUtils.isBlank((CharSequence)platform)) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        if (MarkYn.check(yn)) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(topManId);
            topManCollectBean.setPlatform(platform);
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
        queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
        queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)platform);
        queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)topManId);
        this.topManCollectService.remove((Wrapper)queryWrapper);
        return Result.ok();
    }
}

