/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.TopManDetailBodyParam;
import com.els.modules.industryinfo.dto.TopManInformationParam;
import com.els.modules.industryinfo.entity.TopManDetailHeadEntity;
import com.els.modules.industryinfo.entity.TopManGoodsListEntity;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.entity.TopManResultDetailBody;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyBase;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyFans;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyLive;
import com.els.modules.industryinfo.entity.TopManResultDetailBodySaleGoods;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyVideo;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.entity.TopManShopListEntity;
import com.els.modules.industryinfo.enumerate.StatisticsDateType;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.function.TopManList4ParamFunction;
import com.els.modules.industryinfo.mapper.TopManInformationMapper;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.utils.UnicodeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class TopManInformationServiceImpl
extends BaseServiceImpl<TopManInformationMapper, TopManParamEntity>
implements TopManInformationService {
    HashMap<TopManQueryType, TopManList4ParamFunction<IPage<TopManResultEntity>, Wrapper<TopManParamEntity>, IPage<? extends TopManResultEntity>>> typeMethod = null;

    @Override
    public IPage<? extends TopManResultEntity> queryTopManList(SimplePostRequestParam<TopManInformationParam> topManDto, TopManQueryType topManQueryType) throws IllegalAccessException {
        if (this.typeMethod == null) {
            this.typeMethod = new HashMap<TopManQueryType, TopManList4ParamFunction<IPage<TopManResultEntity>, Wrapper<TopManParamEntity>, IPage<? extends TopManResultEntity>>>(){
                {
                    this.put(TopManQueryType.all, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageAll);
                    this.put(TopManQueryType.myCollection, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageCollection);
                    this.put(TopManQueryType.liveTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageLiveTopMan);
                    this.put(TopManQueryType.videoTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageVideoTopMan);
                }
            };
        }
        QueryWrapper<TopManParamEntity> queryWrapper = this.getQueryWrapper(topManDto);
        queryWrapper.select(TopManParamEntity.getSelectField());
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        String customSqlSegment = queryWrapper.getCustomSqlSegment();
        topManQueryType.getInitMethod().initQueryWrapper(queryWrapper, null);
        IPage<? extends TopManResultEntity> topManBeanIPage = Optional.ofNullable(this.typeMethod.get((Object)topManQueryType)).orElseThrow(() -> new TopManException(I18nUtil.translate((String)"", (String)"\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef"))).apply((IPage<TopManResultEntity>)page, (Wrapper<TopManParamEntity>)queryWrapper, SysUtil.getLoginUser(), StatisticsDateType.M1);
        topManBeanIPage.getRecords().forEach(topManBean -> topManBean.setTopManName(UnicodeUtil.decode(topManBean.getTopManName())));
        return topManBeanIPage;
    }

    @Override
    public TopManDetailHeadEntity queryDetailHead(String id) {
        return ((TopManInformationMapper)this.baseMapper).queryDetailHead(id, SysUtil.getLoginUser(), StatisticsDateType.M1);
    }

    @Override
    public TopManResultDetailBody queryDetailBody(TopManDetailBodyParam param) {
        return BodyType.getTypeWhitName(param.getBodyType()).function.queryDetailBody(param);
    }

    @Override
    public IPage<TopManGoodsListEntity> queryGooodsList(SimplePostRequestParam<TopManDetailBodyParam> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        return ((TopManInformationMapper)this.baseMapper).queryGoodsList(param.getFilterInfo());
    }

    @Override
    public IPage<TopManShopListEntity> queryShopList(SimplePostRequestParam<TopManDetailBodyParam> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        return ((TopManInformationMapper)this.baseMapper).queryShopList(param.getFilterInfo());
    }

    private TopManResultDetailBody queryDetailBodyBase(final TopManDetailBodyParam param) {
        return new TopManResultDetailBodyBase(){
            {
                this.setCategoryAnalysisData(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryCateGoryAnalysisData(param));
                this.setBrandAnalysisData(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryBrandAnalysisData(param));
            }
        };
    }

    private TopManResultDetailBody queryDetailBodySaleGoods(TopManDetailBodyParam param) {
        final TopManResultDetailBodySaleGoods result = ((TopManInformationMapper)this.baseMapper).queryDetailBodySaleGoods(param);
        result.setSaleGoodsCount(new TopManResultDetailBodySaleGoods.SaleGoodsCount(){
            {
                this.setGoodsCategoryCount(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountGoodsCategory(result.getId()));
                this.setGoodsBrandCount(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountGoodsBrand(result.getId()));
            }
        });
        result.setCooperationShopCount(new TopManResultDetailBodySaleGoods.CooperationShopCount(){
            {
                this.setGoodsCategoryOfShopCount(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountShopBrand(result.getId()));
            }
        });
        return result;
    }

    private TopManResultDetailBody queryDetailBodyLive(TopManDetailBodyParam param) {
        return new TopManResultDetailBodyLive(){};
    }

    private TopManResultDetailBody queryDetailBodyVideo(TopManDetailBodyParam param) {
        return new TopManResultDetailBodyVideo(){};
    }

    private TopManResultDetailBody queryDetailBodyFans(TopManDetailBodyParam param) {
        return new TopManResultDetailBodyFans(){};
    }

    @PostConstruct
    private void registerMapper() {
        BodyType.base.function = this::queryDetailBodyBase;
        BodyType.saleGoods.function = this::queryDetailBodySaleGoods;
        BodyType.live.function = this::queryDetailBodyLive;
        BodyType.video.function = this::queryDetailBodyVideo;
        BodyType.fans.function = this::queryDetailBodyFans;
    }

    private QueryWrapper<TopManParamEntity> getQueryWrapper(SimplePostRequestParam<TopManInformationParam> topManDto) throws IllegalAccessException {
        String[] columns;
        String column;
        TopManInformationParam filterInfo = topManDto.getFilterInfo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntityClass(TopManParamEntity.class);
        filterInfo.initQueryWrapper((QueryWrapper<TopManParamEntity>)queryWrapper);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            ((LambdaQueryWrapper)queryWrapper.lambda().like(TopManParamEntity::getTopManName, (Object)keyWord)).or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(TopManParamEntity::getTopManId, (Object)keyWord);
            });
        }
        if ((column = topManDto.getColumn()) != null && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("column", columns);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                }
            }, (Object)((Object)new TopManInformationHead()));
        }
        return queryWrapper;
    }

    private static enum BodyType {
        base,
        saleGoods,
        live,
        video,
        fans;

        private BodyTypeMethodFunction function;

        public static BodyType getTypeWhitName(String name) {
            for (BodyType value : BodyType.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            throw new TopManException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u8fbe\u4eba\u8be6\u60c5\u7684\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef\uff1abase\u3001saleGoods\u3001live\u3001video\u3001fans"));
        }

        @FunctionalInterface
        static interface BodyTypeMethodFunction {
            public TopManResultDetailBody queryDetailBody(TopManDetailBodyParam var1);
        }
    }
}

