/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.entity.StoreHead;
import com.els.modules.industryinfo.entity.StoreTopmanItem;
import com.els.modules.industryinfo.mapper.StoreHeadMapper;
import com.els.modules.industryinfo.mapper.StoreTopmanItemMapper;
import com.els.modules.industryinfo.service.StoreHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StoreHeadServiceImpl
extends BaseServiceImpl<StoreHeadMapper, StoreHead>
implements StoreHeadService {
    @Autowired
    private StoreHeadMapper storeHeadMapper;
    @Autowired
    private StoreTopmanItemMapper storeTopmanItemMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(StoreHead storeHead, List<StoreTopmanItem> storeTopmanItemList) {
        this.storeHeadMapper.insert((Object)storeHead);
        super.setHeadDefaultValue((BaseEntity)storeHead);
        this.insertData(storeHead, storeTopmanItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(StoreHead storeHead, List<StoreTopmanItem> storeTopmanItemList) {
        this.storeHeadMapper.updateById((Object)storeHead);
        this.storeTopmanItemMapper.deleteByMainId(storeHead.getId());
        this.insertData(storeHead, storeTopmanItemList);
    }

    private void insertData(StoreHead storeHead, List<StoreTopmanItem> storeTopmanItemList) {
        if (!CollectionUtils.isEmpty(storeTopmanItemList)) {
            for (StoreTopmanItem entity : storeTopmanItemList) {
                entity.setHeadId(storeHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)storeHead);
            }
            if (!storeTopmanItemList.isEmpty()) {
                this.storeTopmanItemMapper.insertBatchSomeColumn(storeTopmanItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.storeTopmanItemMapper.deleteByMainId(id);
        this.storeHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.storeTopmanItemMapper.deleteByMainId(serializable.toString());
            this.storeHeadMapper.deleteById(serializable);
        }
    }
}

