/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.vo.CountVO;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.dto.GoodsItemQueryDTO;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsFavorite;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsLiveItem;
import com.els.modules.industryinfo.entity.GoodsLiveRecord;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsVideoItem;
import com.els.modules.industryinfo.entity.GoodsVideoRecord;
import com.els.modules.industryinfo.excel.GoodsHeadExportServiceImpl;
import com.els.modules.industryinfo.excel.GoodsHeadStatisticsExportServiceImpl;
import com.els.modules.industryinfo.excel.GoodsTopmanItemExportServiceImpl;
import com.els.modules.industryinfo.service.GoodsFavoriteService;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.GoodsLiveItemService;
import com.els.modules.industryinfo.service.GoodsLiveRecordService;
import com.els.modules.industryinfo.service.GoodsTopmanItemService;
import com.els.modules.industryinfo.service.GoodsVideoItemService;
import com.els.modules.industryinfo.service.GoodsVideoRecordService;
import com.els.modules.industryinfo.vo.GoodsHeadStatisticsVO;
import com.els.modules.industryinfo.vo.GoodsHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/industryinfo/goodsHead"})
@Api(tags={"\u5546\u54c1\u4fe1\u606f\u5934"})
public class GoodsHeadController
extends BaseController<GoodsHead, GoodsHeadService> {
    private static final Logger log = LoggerFactory.getLogger(GoodsHeadController.class);
    @Autowired
    private GoodsHeadService goodsHeadService;
    @Autowired
    private GoodsTopmanItemService goodsTopmanItemService;
    @Autowired
    private GoodsVideoItemService goodsVideoItemService;
    @Autowired
    private GoodsVideoRecordService goodsVideoRecordService;
    @Autowired
    private GoodsLiveItemService goodsLiveItemService;
    @Autowired
    private GoodsLiveRecordService goodsLiveRecordService;
    @Autowired
    private GoodsFavoriteService goodsFavoriteService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(GoodsHead goodsHead, GoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsHead> pageList = this.goodsHeadService.queryPage((Page<GoodsHead>)page, (QueryWrapper<GoodsHead>)queryWrapper, queryDTO);
        List<GoodsHead> headList = this.goodsHeadService.collateList(pageList.getRecords(), queryDTO);
        pageList.setRecords(headList);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6211\u7684\u6536\u85cf\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u6211\u7684\u6536\u85cf\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/favoriteList"})
    public Result<?> queryPageFavoriteList(GoodsHead goodsHead, GoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsHead> pageList = this.goodsHeadService.queryFavoritePage((Page<GoodsHead>)page, (QueryWrapper<GoodsHead>)queryWrapper, queryDTO);
        List<GoodsHead> headList = this.goodsHeadService.collateList(pageList.getRecords(), queryDTO);
        pageList.setRecords(headList);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u5546\u54c1\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody GoodsHeadVO headVO) {
        GoodsHead goodsHead = new GoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        goodsHead.setBusAccount(this.getTenantId());
        this.goodsHeadService.saveMain(goodsHead, headVO);
        return Result.ok((Object)((Object)goodsHead));
    }

    @AutoLog(busModule="\u5546\u54c1\u4fe1\u606f\u5934", value="\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    @GetMapping(value={"/favorite"})
    public Result<?> favorite(@RequestParam(name="id") String id) {
        this.goodsHeadService.favorite(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5546\u54c1\u4fe1\u606f\u5934", value="\u53d6\u6d88\u6536\u85cf")
    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf", notes="\u53d6\u6d88\u6536\u85cf")
    @GetMapping(value={"/cancelFavorite"})
    public Result<?> cancelFavorite(@RequestParam(name="id") String id) {
        this.goodsHeadService.cancelFavorite(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        GoodsHead goodsHead = (GoodsHead)((Object)this.goodsHeadService.getById((Serializable)((Object)id)));
        GoodsHeadVO goodsHeadVO = new GoodsHeadVO();
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsHeadVO));
        String elsAccount = this.getTenantId();
        GoodsFavorite goodsFavorite = this.goodsFavoriteService.selectGoodsFavorite(goodsHead.getId(), elsAccount);
        goodsHeadVO.setFavoriteGoods(false);
        if (goodsFavorite != null) {
            goodsHeadVO.setFavoriteGoods(true);
        }
        return Result.ok((Object)((Object)goodsHeadVO));
    }

    @ApiOperation(value="\u5546\u54c1\u4fe1\u606f\u7edf\u8ba1\u5217\u8868", notes="\u5546\u54c1\u4fe1\u606f\u884c\u5217\u8868")
    @GetMapping(value={"/goodsList"})
    public Result<?> goodsList(GoodsTopmanItem topmanItem, GoodsTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topmanItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsTopmanItem> pageList = this.goodsTopmanItemService.queryTopmanPage((Page<GoodsTopmanItem>)page, (QueryWrapper<GoodsTopmanItem>)queryWrapper, queryDTO);
        List<GoodsTopmanItem> itemList = this.goodsTopmanItemService.statisticsList(pageList.getRecords(), queryDTO);
        GoodsHead goodsHead = this.goodsHeadService.collateById(topmanItem.getGoodsId(), queryDTO);
        GoodsHeadStatisticsVO result = new GoodsHeadStatisticsVO();
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)result);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("result", result);
        returnMap.put("itemList", itemList);
        return Result.ok(returnMap);
    }

    @ApiOperation(value="\u901a\u8fc7\u5546\u54c1\u4fe1\u606f\u5934id\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u8fbe\u4eba\u63a8\u5e7f\u884c", notes="\u901a\u8fc7\u5546\u54c1\u4fe1\u606f\u5934id\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u8fbe\u4eba\u63a8\u5e7f\u884c")
    @GetMapping(value={"/queryGoodsTopmanItemByMainId"})
    public Result<?> queryGoodsTopmanItemListByMainId(@RequestParam(name="id") String id) {
        List<GoodsTopmanItem> goodsTopmanItemList = this.goodsTopmanItemService.selectByMainId(id);
        return Result.ok(goodsTopmanItemList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(GoodsTopmanItem topmanItem, GoodsTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topmanItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsTopmanItem> pageList = this.goodsTopmanItemService.queryTopmanPage((Page<GoodsTopmanItem>)page, (QueryWrapper<GoodsTopmanItem>)queryWrapper, queryDTO);
        List<GoodsTopmanItem> itemList = this.goodsTopmanItemService.collateList(pageList.getRecords(), queryDTO);
        pageList.setRecords(itemList);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5546\u54c1\u4fe1\u606f\u5934id\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u89c6\u9891\u63a8\u5e7f\u884c", notes="\u901a\u8fc7\u5546\u54c1\u4fe1\u606f\u5934id\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u89c6\u9891\u63a8\u5e7f\u884c")
    @GetMapping(value={"/queryGoodsVideoItemByMainId"})
    public Result<?> queryGoodsVideoItemListByMainId(@RequestParam(name="id") String id) {
        List<GoodsVideoItem> goodsVideoItemList = this.goodsVideoItemService.selectByMainId(id);
        return Result.ok(goodsVideoItemList);
    }

    @ApiOperation(value="\u89c6\u9891\u4fe1\u606f\u5217\u8868", notes="\u89c6\u9891\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/videoList"})
    public Result<?> videoList(GoodsVideoRecord videoList, GoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List<GoodsVideoItem> itemList = this.goodsVideoItemService.videoList(videoList.getGoodsId(), queryDTO);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)videoList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsVideoRecord> pageList = this.goodsVideoRecordService.queryVideoPage((Page<GoodsVideoRecord>)page, (QueryWrapper<GoodsVideoRecord>)queryWrapper, queryDTO);
        HashMap<String, List<BaseEntity>> returnMap = new HashMap<String, List<BaseEntity>>();
        returnMap.put("itemList", itemList);
        returnMap.put("pageList", (List<BaseEntity>)pageList);
        return Result.ok(returnMap);
    }

    @ApiOperation(value="\u901a\u8fc7\u5546\u54c1\u4fe1\u606f\u5934id\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u76f4\u64ad\u63a8\u5e7f\u884c", notes="\u901a\u8fc7\u5546\u54c1\u4fe1\u606f\u5934id\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u76f4\u64ad\u63a8\u5e7f\u884c")
    @GetMapping(value={"/queryGoodsLiveItemByMainId"})
    public Result<?> queryGoodsLiveItemListByMainId(@RequestParam(name="id") String id) {
        List<GoodsLiveItem> goodsLiveItemList = this.goodsLiveItemService.selectByMainId(id);
        return Result.ok(goodsLiveItemList);
    }

    @ApiOperation(value="\u76f4\u64ad\u4fe1\u606f\u5217\u8868", notes="\u76f4\u64ad\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/liveList"})
    public Result<?> liveList(GoodsLiveRecord liveList, GoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List<GoodsLiveItem> itemList = this.goodsLiveItemService.videoList(liveList.getGoodsId(), queryDTO);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)liveList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsLiveRecord> pageList = this.goodsLiveRecordService.queryLivePage((Page<GoodsLiveRecord>)page, (QueryWrapper<GoodsLiveRecord>)queryWrapper, queryDTO);
        HashMap<String, List<BaseEntity>> returnMap = new HashMap<String, List<BaseEntity>>();
        returnMap.put("itemList", itemList);
        returnMap.put("pageList", (List<BaseEntity>)pageList);
        return Result.ok(returnMap);
    }

    @ApiOperation(value="\u5546\u54c1\u4fe1\u606f\u5217\u8868-\u5bfc\u51fa", notes="\u5546\u54c1\u4fe1\u606f\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, GoodsHeadExportServiceImpl.class);
    }

    @ApiOperation(value="\u5546\u54c1\u4fe1\u606f\u7edf\u8ba1\u5217\u8868-\u5bfc\u51fa", notes="\u5546\u54c1\u4fe1\u606f\u5934-\u5bfc\u51fa")
    @GetMapping(value={"/statisticsExportXls"})
    public ModelAndView statisticsExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, GoodsHeadStatisticsExportServiceImpl.class);
    }

    @ApiOperation(value="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u5bfc\u51fa", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/topmanExportXls"})
    public ModelAndView topmanExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, GoodsTopmanItemExportServiceImpl.class);
    }

    @ApiOperation(value="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(GoodsTopmanItem goodsTopmanItem, HttpServletRequest req) {
        List<CountVO> result = this.goodsTopmanItemService.contentTypeCounts(goodsTopmanItem, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(GoodsTopmanItem goodsTopmanItem, HttpServletRequest req) {
        List<CountVO> result = this.goodsTopmanItemService.goodsWomCounts(goodsTopmanItem, req);
        return Result.ok(result);
    }
}

