/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsTopmanRecord;
import com.els.modules.industryinfo.mapper.GoodsTopmanItemMapper;
import com.els.modules.industryinfo.service.GoodsTopmanItemService;
import com.els.modules.industryinfo.service.GoodsTopmanRecordService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsTopmanItemServiceImpl
extends BaseServiceImpl<GoodsTopmanItemMapper, GoodsTopmanItem>
implements GoodsTopmanItemService {
    @Autowired
    private GoodsTopmanItemMapper goodsTopmanItemMapper;
    @Autowired
    private GoodsTopmanRecordService goodsTopmanRecordService;

    @Override
    public List<GoodsTopmanItem> selectByMainId(String mainId) {
        return this.goodsTopmanItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<GoodsTopmanRecord> statisticsList(GoodsTopmanItemQueryDTO queryDTO) {
        List<GoodsTopmanItem> list = this.queryList(queryDTO);
        QueryWrapper queryWrapper = new QueryWrapper();
        List records = this.goodsTopmanRecordService.list((Wrapper)queryWrapper);
        ArrayList<GoodsTopmanRecord> itemList = new ArrayList<GoodsTopmanRecord>();
        if (CollectionUtil.isNotEmpty(list)) {
            Map<String, List<GoodsTopmanItem>> itemMap = list.stream().collect(Collectors.groupingBy(h -> DateUtil.format((Date)h.getUpdateTime(), (String)"yyyy-MM-dd")));
            Map<Object, Object> recordMap = new HashMap();
            if (CollectionUtil.isNotEmpty(list)) {
                recordMap = records.stream().collect(Collectors.groupingBy(h -> DateUtil.format((Date)h.getUpdateTime(), (String)"yyyy-MM-dd")));
            }
            for (Map.Entry<String, List<GoodsTopmanItem>> entry : itemMap.entrySet()) {
                List<GoodsTopmanItem> value = entry.getValue();
                String timeSelect = queryDTO.getTopmanTimeSelect();
                if (StringUtils.isBlank((CharSequence)timeSelect)) {
                    timeSelect = "1";
                }
                BigDecimal salesNum = value.stream().map(GoodsTopmanItem::getSalesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal salesAmountMin = value.stream().map(GoodsTopmanItem::getSalesAmountMin).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal salesAmountMax = value.stream().map(GoodsTopmanItem::getSalesAmountMax).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal browsesNum = value.stream().map(GoodsTopmanItem::getBrowsesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal videosNum = value.stream().map(GoodsTopmanItem::getVideosNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal livesNum = value.stream().map(GoodsTopmanItem::getLivesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                GoodsTopmanRecord item = new GoodsTopmanRecord();
                item.setStatisticTime(entry.getKey());
                item.setSalesNum(salesNum);
                item.setSalesAmountMin(salesAmountMin);
                item.setSalesAmountMax(salesAmountMax);
                item.setBrowsesNum(browsesNum);
                if (CollectionUtil.isNotEmpty((Collection)((Collection)recordMap.get(entry.getKey())))) {
                    int size = ((List)recordMap.get(entry.getKey())).size();
                    item.setTopmanNum(new BigDecimal(size));
                }
                item.setVideosNum(videosNum);
                item.setLivesNum(livesNum);
                item.setQueryDay(timeSelect);
                itemList.add(item);
            }
            itemList.sort((o1, o2) -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date dt1 = format.parse(o1.getStatisticTime());
                    Date dt2 = format.parse(o2.getStatisticTime());
                    return Long.compare(dt2.getTime(), dt1.getTime());
                }
                catch (Exception e) {
                    return 0;
                }
            });
        }
        return itemList;
    }

    @Override
    public List<GoodsTopmanItem> queryList(GoodsTopmanItemQueryDTO queryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.lambda().eq(GoodsTopmanItem::getQueryDay, (Object)timeSelect);
        return ((GoodsTopmanItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }
}

