/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.vo.CountVO;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.dto.StoreHeadQueryDTO;
import com.els.modules.industryinfo.dto.StoreTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.StoreHead;
import com.els.modules.industryinfo.entity.StoreTopmanRecord;
import com.els.modules.industryinfo.excel.StoreHeadExportServiceImpl;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.StoreHeadService;
import com.els.modules.industryinfo.service.StoreTopmanRecordService;
import com.els.modules.industryinfo.vo.StoreHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/industryinfo/storeHead"})
@Api(tags={"\u5e97\u94fa\u4fe1\u606f\u5934"})
public class StoreHeadController
extends BaseController<StoreHead, StoreHeadService> {
    private static final Logger log = LoggerFactory.getLogger(StoreHeadController.class);
    @Autowired
    private StoreHeadService storeHeadService;
    @Autowired
    private StoreTopmanRecordService storeTopmanRecordService;
    @Autowired
    private GoodsHeadService goodsHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(StoreHead storeHead, StoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)storeHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<StoreHead> pageList = this.storeHeadService.queryPage((Page<StoreHead>)page, (QueryWrapper<StoreHead>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6211\u7684\u6536\u85cf\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u6211\u7684\u6536\u85cf\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/favoriteList"})
    public Result<?> queryPageFavoriteList(StoreHead storeHead, StoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)storeHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<StoreHead> pageList = this.storeHeadService.queryFavoritePage((Page<StoreHead>)page, (QueryWrapper<StoreHead>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u5e97\u94fa\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody StoreHeadVO headVO) {
        StoreHead storeHead = new StoreHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)storeHead));
        storeHead.setBusAccount(this.getTenantId());
        this.storeHeadService.saveMain(storeHead, headVO);
        return Result.ok((Object)((Object)storeHead));
    }

    @AutoLog(busModule="\u5e97\u94fa\u4fe1\u606f\u5934", value="\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    @GetMapping(value={"/favorite"})
    public Result<?> favorite(@RequestParam(name="id") String id) {
        this.storeHeadService.favorite(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5e97\u94fa\u4fe1\u606f\u5934", value="\u53d6\u6d88\u6536\u85cf")
    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf", notes="\u53d6\u6d88\u6536\u85cf")
    @GetMapping(value={"/cancelFavorite"})
    public Result<?> cancelFavorite(@RequestParam(name="id") String id) {
        this.storeHeadService.cancelFavorite(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        StoreHeadVO headVO = this.storeHeadService.queryById(id);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(StoreTopmanRecord topmanRecord, StoreTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topmanRecord), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<StoreTopmanRecord> pageList = this.storeTopmanRecordService.queryTopmanPage((Page<StoreTopmanRecord>)page, (QueryWrapper<StoreTopmanRecord>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(StoreTopmanRecord topmanRecord, HttpServletRequest req) {
        List<CountVO> result = this.storeTopmanRecordService.contentTypeCounts(topmanRecord, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(StoreTopmanRecord topmanRecord, HttpServletRequest req) {
        List<CountVO> result = this.storeTopmanRecordService.goodsWomCounts(topmanRecord, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5546\u54c1\u4fe1\u606f\u5217\u8868", notes="\u5546\u54c1\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/goodsList"})
    public Result<?> queryPageList(GoodsHead goodsHead, GoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("30");
        }
        IPage<GoodsHead> pageList = this.goodsHeadService.queryPage((Page<GoodsHead>)page, (QueryWrapper<GoodsHead>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u4fe1\u606f\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5546\u54c1\u4fe1\u606f\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/categoryCounts"})
    public Result<?> contentTypeCounts(GoodsHead goodsHead, HttpServletRequest req) {
        List<CountVO> result = this.goodsHeadService.categoryCounts(goodsHead, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5e97\u94fa\u4fe1\u606f\u5217\u8868-\u5bfc\u51fa", notes="\u5e97\u94fa\u4fe1\u606f\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, StoreHeadExportServiceImpl.class);
    }
}

