/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsTopmanRecord;
import com.els.modules.industryinfo.mapper.GoodsTopmanItemMapper;
import com.els.modules.industryinfo.service.GoodsTopmanItemService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsTopmanItemServiceImpl
extends BaseServiceImpl<GoodsTopmanItemMapper, GoodsTopmanItem>
implements GoodsTopmanItemService {
    @Autowired
    private GoodsTopmanItemMapper goodsTopmanItemMapper;

    @Override
    public List<GoodsTopmanItem> selectByMainId(String mainId) {
        return this.goodsTopmanItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<GoodsTopmanRecord> statisticsList(List<GoodsTopmanRecord> list, GoodsTopmanItemQueryDTO queryDTO) {
        ArrayList<GoodsTopmanRecord> itemList = new ArrayList<GoodsTopmanRecord>();
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> recordIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<GoodsTopmanItem> items = this.queryList(recordIds, queryDTO);
            Map<String, GoodsTopmanItem> itemMap = items.stream().collect(Collectors.toMap(GoodsTopmanItem::getRecordId, h -> h, (k1, k2) -> k1));
            for (GoodsTopmanRecord record : list) {
                GoodsTopmanItem item = itemMap.get(record.getId());
                record.setStatisticTime(DateUtil.format((Date)record.getCreateTime(), (String)"yyyy-MM-dd"));
                if (item != null) {
                    record.setVideosNum(item.getVideosNum());
                    record.setLivesNum(item.getLivesNum());
                    record.setSalesNum(item.getSalesNum());
                    record.setSalesAmountMin(item.getSalesAmountMin());
                    record.setSalesAmountMax(item.getSalesAmountMax());
                    record.setBrowsesNum(item.getBrowsesNum());
                    record.setTopmanNum(item.getTopmanNum());
                    record.setQueryDay(item.getQueryDay());
                }
                itemList.add(record);
            }
        }
        return itemList;
    }

    @Override
    public List<GoodsTopmanItem> queryList(GoodsTopmanItemQueryDTO queryDTO) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.eq(GoodsTopmanItem::getQueryDay, (Object)timeSelect);
        return ((GoodsTopmanItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    private List<GoodsTopmanItem> queryList(List<String> recordIds, GoodsTopmanItemQueryDTO queryDTO) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.eq(GoodsTopmanItem::getQueryDay, (Object)timeSelect);
        queryWrapper.in(BaseEntity::getId, recordIds);
        return ((GoodsTopmanItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }
}

