/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.industryinfo.entity.TopManBrandAnalysisItem;
import com.els.modules.industryinfo.entity.TopManCategoryAnalysisItem;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.entity.TopManLiveItemList;
import com.els.modules.industryinfo.entity.TopManLiveItemMain;
import com.els.modules.industryinfo.job.utils.DataFormatUtils;
import com.els.modules.industryinfo.service.TopManBrandAnalysisItemService;
import com.els.modules.industryinfo.service.TopManCategoryAnalysisItemService;
import com.els.modules.industryinfo.service.TopManInformationHeadService;
import com.els.modules.industryinfo.service.TopManLiveItemListService;
import com.els.modules.industryinfo.service.TopManLiveItemMainService;
import com.mongodb.client.MongoCursor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TopManJob.class);
    @Resource
    private TopManInformationHeadService topManInformationHeadService;
    @Resource
    private TopManBrandAnalysisItemService topManBrandAnalysisItemService;
    @Resource
    private TopManCategoryAnalysisItemService topManCategoryAnalysisItemService;
    @Resource
    private TopManLiveItemMainService topManLiveItemMainService;
    @Resource
    private TopManLiveItemListService topManLiveItemListService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TOPMAN_DATA_NAME = "tb_topman_data";
    private final String TOPMAN_COLLECTION_NAME = "tb_doudian_daren_uid";
    private final String TOPMAN_CORE_DATA_NAME = "tb_doudian_daren_overview";
    private final String TOPMAN_PROFILE_NAME = "tb_doudian_daren_profile";
    private final String TOPMAN_LIVE_DATA_NAME = "tb_doudian_daren_LiveDetail";
    private final int BATCH_SIZE = 500;

    public void execute(String parameter) {
        log.info("------------start TopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_daren_uid").find().noCursorTimeout(true).batchSize(500).cursor();){
            ArrayList<TopManInformationHead> entityList = new ArrayList<TopManInformationHead>();
            log.info("------------start TopManJob cursor -----------1");
            while (cursor.hasNext()) {
                ++i;
                Document doc = (Document)cursor.next();
                try {
                    String id = doc.getString((Object)"_id");
                    Document inquerDoc = new Document();
                    inquerDoc.append("_id", (Object)id);
                    Document topmapData = (Document)this.mongoTemplate.getCollection("tb_topman_data").find((Bson)inquerDoc).first();
                    Document profileData = (Document)this.mongoTemplate.getCollection("tb_doudian_daren_profile").find((Bson)inquerDoc).first();
                    entityList.add(this.genTopMan(doc, profileData, topmapData));
                    this.genCoreData(doc, id);
                    this.genLiveData(doc);
                }
                catch (Exception e) {
                    log.error("doc error ", (Object)doc);
                    log.error("genTopMan error ", (Throwable)e);
                }
                if (i % 1000 != 0) continue;
                log.info("------------start TopManJob cursor -----------" + i);
                try {
                    this.topManInformationHeadService.saveOrUpdateBatch(entityList);
                }
                catch (Exception e) {
                    log.error("saveOrUpdateBatch error", (Throwable)e);
                }
                entityList = new ArrayList();
            }
            log.info("------------start TopManJob cursor -----------" + i);
            this.topManInformationHeadService.saveOrUpdateBatch(entityList);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    @Async
    private void genLiveData(Document doc) {
        Document inquerDoc = new Document();
        String id = doc.getString((Object)"_id");
        inquerDoc.append("invite_id", (Object)id);
        this.topManLiveItemMainService.deleteByMainId(id);
        this.topManLiveItemListService.deleteByMainId(id);
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_daren_LiveDetail").find((Bson)inquerDoc).noCursorTimeout(true).cursor();){
            ArrayList<TopManLiveItemMain> entityList = new ArrayList<TopManLiveItemMain>();
            while (cursor.hasNext()) {
                Document liveData = (Document)cursor.next();
                entityList.add(this.getLiveMain(liveData, id));
            }
            this.topManLiveItemMainService.saveBatch(entityList);
        }
        catch (Exception e) {
            log.error("genCoreData error", (Throwable)e);
        }
    }

    private TopManLiveItemMain getLiveMain(Document doc, String id) throws ParseException {
        TopManLiveItemMain itemMain = new TopManLiveItemMain();
        itemMain.setId(doc.getString((Object)"_id"));
        itemMain.setHeadId(id);
        itemMain.setElsAccount("100000");
        itemMain.setStatisticsType(doc.getString((Object)"days"));
        itemMain.setStatisticsDate(doc.getString((Object)"date"));
        itemMain.setInteractionRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"interact_rate")));
        itemMain.setLiveQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"live_count")));
        itemMain.setLiveDays(DataFormatUtils.numberToBigDecimal(doc.get((Object)"work_day_count")));
        itemMain.setLiveDurationAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"live_duration")));
        itemMain.setLiveViewers(DataFormatUtils.numberToBigDecimal(doc.get((Object)"watching_num")));
        itemMain.setOnlinePopulationAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"online_avg")));
        itemMain.setOnlinePopulationMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"online_peak")));
        itemMain.setWatchDurationAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"watching_duration_avg")));
        this.genLiveRecode((List)doc.get((Object)"LiveDetail_List", List.class), id, doc.getString((Object)"_id"));
        return itemMain;
    }

    @Async
    private void genLiveRecode(List<Document> lives, String headId, String mainId) throws ParseException {
        ArrayList<TopManLiveItemList> entityList = new ArrayList<TopManLiveItemList>();
        for (Document recode : lives) {
            TopManLiveItemList item = new TopManLiveItemList();
            item.setMainId(mainId);
            item.setHeadId(headId);
            item.setElsAccount("100000");
            item.setLiveId(recode.getString((Object)"roomId"));
            item.setWatchQuantity(DataFormatUtils.stringToBigDecimal(recode.getString((Object)"viewer")));
            item.setGoodsQuantity(DataFormatUtils.stringToBigDecimal(recode.getString((Object)"promotion_sum")));
            item.setWatchDurationAvg(DataFormatUtils.stringToBigDecimal(recode.getString((Object)"average_watching_time")));
            List dateSection = recode.getList((Object)"date_section", String.class);
            item.setLiveTime(DataFormatUtils.stringToDate((String)dateSection.get(0)));
            entityList.add(item);
        }
        this.topManLiveItemListService.saveBatch(entityList);
    }

    private void genCoreData(Document doc, String id) {
        Document inquerDoc = new Document();
        inquerDoc.append("invite_id", (Object)id);
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_daren_overview").find((Bson)inquerDoc).noCursorTimeout(true).cursor();){
            ArrayList<TopManBrandAnalysisItem> breadList = new ArrayList<TopManBrandAnalysisItem>();
            ArrayList<TopManCategoryAnalysisItem> categoryList = new ArrayList<TopManCategoryAnalysisItem>();
            this.topManBrandAnalysisItemService.deleteByMainId(id);
            this.topManCategoryAnalysisItemService.deleteByMainId(id);
            log.info("------------start TopManJob cursor -----------1");
            while (cursor.hasNext()) {
                Document coreData = (Document)cursor.next();
                Document saleAnalysis = (Document)coreData.get((Object)"sale_analysis", Document.class);
                String days = coreData.getString((Object)"days");
                breadList.addAll(this.genBrandItem(saleAnalysis, id, days));
                categoryList.addAll(this.genTopManCategoryAnalysisItem(saleAnalysis, id, days));
            }
            this.topManBrandAnalysisItemService.saveBatch(breadList);
            this.topManCategoryAnalysisItemService.saveBatch(categoryList);
        }
        catch (Exception e) {
            log.error("genCoreData error", (Throwable)e);
        }
    }

    private List<TopManBrandAnalysisItem> genBrandItem(Document saleAnalysis, String headId, String days) {
        ArrayList<TopManBrandAnalysisItem> entityList = new ArrayList<TopManBrandAnalysisItem>();
        List liveBrand = (List)((Document)saleAnalysis.get((Object)"live", Document.class)).get((Object)"brand", List.class);
        for (Document doc : liveBrand) {
            entityList.add(this.getBrand(doc, "1", headId, days));
        }
        List videoBrand = (List)((Document)saleAnalysis.get((Object)"video", Document.class)).get((Object)"brand", List.class);
        for (Document doc : videoBrand) {
            entityList.add(this.getBrand(doc, "2", headId, days));
        }
        return entityList;
    }

    private TopManBrandAnalysisItem getBrand(Document doc, String popularizeType, String headId, String days) {
        TopManBrandAnalysisItem brand = new TopManBrandAnalysisItem();
        brand.setHeadId(headId);
        brand.setElsAccount("100000");
        brand.setPopularizeType(popularizeType);
        brand.setBrand(doc.getString((Object)"brand"));
        brand.setStatisticsType(days);
        brand.setPriceAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_price")));
        brand.setSaleAmountMin(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_low")));
        brand.setSaleAmountMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_high")));
        return brand;
    }

    private List<TopManCategoryAnalysisItem> genTopManCategoryAnalysisItem(Document saleAnalysis, String headId, String days) {
        ArrayList<TopManCategoryAnalysisItem> entityList = new ArrayList<TopManCategoryAnalysisItem>();
        List liveCategory = (List)((Document)saleAnalysis.get((Object)"live", Document.class)).get((Object)"catogory", List.class);
        for (Document doc : liveCategory) {
            entityList.add(this.getCategoryAnalysis(doc, "1", headId, days));
        }
        List videoCategory = (List)((Document)saleAnalysis.get((Object)"video", Document.class)).get((Object)"catogory", List.class);
        for (Document doc : videoCategory) {
            entityList.add(this.getCategoryAnalysis(doc, "1", headId, days));
        }
        return entityList;
    }

    private TopManCategoryAnalysisItem getCategoryAnalysis(Document doc, String popularizeType, String headId, String days) {
        TopManCategoryAnalysisItem category = new TopManCategoryAnalysisItem();
        category.setHeadId(headId);
        category.setElsAccount("100000");
        category.setPopularizeType(popularizeType);
        category.setCategory(doc.getString((Object)"category"));
        category.setPriceAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_price")));
        category.setStatisticsType(days);
        category.setSaleAmountMin(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_low")));
        category.setSaleAmountMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_high")));
        category.setCommissionRateMin(DataFormatUtils.numberToBigDecimal(doc.get((Object)"suggest_ratio_min")));
        category.setCommissionRateMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"suggest_ratio_max")));
        return category;
    }

    private TopManInformationHead genTopMan(Document doc, Document profileData, Document topmapData) {
        Document base = (Document)doc.get((Object)"author_base");
        Document contact = (Document)doc.get((Object)"author_contact");
        TopManInformationHead bean = new TopManInformationHead();
        bean.setId(doc.getString((Object)"_id"));
        bean.setElsAccount("100000");
        bean.setPlatform("1");
        bean.setTopmanName(base.getString((Object)"nickname"));
        bean.setTopmanId(base.getString((Object)"uid"));
        bean.setTopmanAvatar(base.getString((Object)"avatar_big"));
        bean.setFansNum(DataFormatUtils.numberToBigDecimal(base.get((Object)"fans_num")));
        bean.setTopmanSex(DataFormatUtils.numberToString(base.getInteger((Object)"gender")));
        bean.setRegion(base.getString((Object)"city"));
        bean.setTopmanLevel(DataFormatUtils.numberToString(base.get((Object)"author_level")));
        bean.setMobile(contact.getString((Object)"phone"));
        bean.setWechat(contact.getString((Object)"wechat"));
        this.genData(topmapData, bean);
        if (profileData != null && !profileData.isEmpty()) {
            bean.setRemark(profileData.getString((Object)"introduction"));
            bean.setGoodsWom(profileData.getString((Object)"score"));
            bean.setCreditScore(DataFormatUtils.numberToString(profileData.get((Object)"credit_score")));
            bean.setCooperationMode(DataFormatUtils.numberToString(profileData.get((Object)"sell_requirement")));
        }
        return bean;
    }

    private void genData(Document topmanData, TopManInformationHead bean) {
        if (topmanData != null && !topmanData.isEmpty()) {
            bean.setXingtuTopman("1");
            bean.setQuoteOfLive(DataFormatUtils.stringToBigDecimal(topmanData.getString((Object)"price_60")));
        }
    }

    public void doScheduled() {
        log.info("------------start TopManJob Scheduled-----------");
        this.execute(null);
    }
}

