/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialCodeImportImpl")
public class PurchaseMaterialCodeImportImpl
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        ArrayList<PurchaseMaterialCode> entityList = new ArrayList<PurchaseMaterialCode>();
        for (Map<String, Object> data : dataList) {
            PurchaseMaterialCode entity = (PurchaseMaterialCode)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseMaterialCode.class));
            entity.setElsAccount(elsAccount);
            entity.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
            entity.setSourceType(StrUtil.emptyToDefault((CharSequence)entity.getSourceType(), (String)"2"));
            entity.setUpCateCode(StrUtil.emptyToDefault((CharSequence)entity.getUpCateCode(), (String)""));
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        List<String> codes = entityList.stream().map(PurchaseMaterialCode::getCateCode).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        if (codes.size() != Sets.newHashSet(codes).size()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)"\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a"));
        }
        List<PurchaseMaterialCode> existList = this.purchaseMaterialCodeService.listByCodeList(codes, elsAccount);
        if (CollUtil.isNotEmpty(existList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a" + existList.stream().map(PurchaseMaterialCode::getCateCode).distinct().collect(Collectors.joining(",")))));
        }
        List<String> parentCodeList = entityList.stream().map(PurchaseMaterialCode::getUpCateCode).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
        List<PurchaseMaterialCode> parentList = this.purchaseMaterialCodeService.listByCodeList(parentCodeList, elsAccount);
        Map parentMap = parentList.stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity(), (v1, v2) -> v2));
        Map currentMap = entityList.stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity(), (v1, v2) -> v2));
        for (PurchaseMaterialCode code : entityList) {
            if (!StrUtil.isNotEmpty((CharSequence)code.getUpCateCode())) continue;
            PurchaseMaterialCode tem = (PurchaseMaterialCode)((Object)parentMap.get(code.getUpCateCode()));
            if (null == tem) {
                tem = (PurchaseMaterialCode)((Object)currentMap.get(code.getUpCateCode()));
            }
            if (null != tem) {
                code.setUpCateName(tem.getUpCateName());
                continue;
            }
            code.setUpCateCode("");
            code.setUpCateName(null);
        }
        this.purchaseMaterialCodeService.saveBatch(entityList);
        return dataList;
    }
}

