/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.job;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.service.SrmToIPaasRpcService;
import com.els.modules.material.enumerate.AsianMetalTypeEnum;
import com.els.modules.thirddata.entity.BulkMaterialPrice;
import com.els.modules.thirddata.service.BulkMaterialPriceService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsianMetalPriceDataJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(AsianMetalPriceDataJob.class);
    private static final String DEFUALT_LANGUAGE = "1";
    private static final String DATA_SOURCE = "1";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SrmToIPaasRpcService srmToIPaasRpcService;
    @Autowired
    private BulkMaterialPriceService bulkMaterialPriceService;

    public void execute(String parameter) {
        JSONObject object = JSONObject.parseObject((String)parameter);
        String language = StringUtils.isBlank((CharSequence)object.getString("language")) ? "1" : object.getString("language");
        String elsAccount = StringUtils.isBlank((CharSequence)object.getString("elsAccount")) ? "100000" : object.getString("elsAccount");
        JSONObject request = new JSONObject();
        request.put("language", (Object)language);
        request.put("time", (Object)this.sdf.format(new Date()));
        request.put("priceSource", (Object)"1");
        JSONObject detailResponse = this.srmToIPaasRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getAsianmetalSpecificationDetail"));
        JSONArray detailArray = this.judugeResult(detailResponse);
        HashMap<String, Object> detailMap = null;
        if (detailArray != null && detailArray.size() > 0) {
            detailMap = new HashMap<String, Object>();
            for (Object detail : detailArray) {
                JSONObject detailObject = JSONObject.parseObject((String)detail.toString());
                BulkMaterialPrice price = (BulkMaterialPrice)((Object)SysUtil.copyProperties(detail, BulkMaterialPrice.class));
                price.setMakeAddr(detailObject.getString("origin"));
                price.setRegion(detailObject.getString("location"));
                price.setMaterialSpec(detailObject.getString("specification"));
                price.setCategoryName(object.getString("product"));
                price.setClassification(AsianMetalTypeEnum.getByValue(detailObject.getString("priceType")));
                price.setMaterialListType(price.getClassification());
                price.setPriceDate(new Date());
                price.setPriceUnit(detailObject.getString("unit"));
                price.setSourceSystem("\u4e9a\u6d32\u91d1\u5c5e\u7f51");
                price.setPriceSource("\u4e9a\u6d32\u91d1\u5c5e\u7f51");
                price.setSourceId(detailObject.getString("priceId"));
                detailMap.put(detailObject.getString("priceId"), (Object)price);
            }
        }
        JSONObject response = this.srmToIPaasRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getAsianmetalPrice"));
        JSONArray priceList = this.judugeResult(response);
        ArrayList<BulkMaterialPrice> bulkMaterialPriceList = null;
        if (priceList != null && priceList.size() > 0) {
            bulkMaterialPriceList = new ArrayList<BulkMaterialPrice>();
            for (Object detail : priceList) {
                JSONObject detailObject = JSONObject.parseObject((String)detail.toString());
                BulkMaterialPrice price = new BulkMaterialPrice();
                if (detailMap != null && detailMap.containsKey(detailObject.getString("priceId"))) {
                    price = (BulkMaterialPrice)((Object)SysUtil.copyProperties(detailMap.get(detailObject.getString("priceId")), BulkMaterialPrice.class));
                } else {
                    price.setCategoryName(detailObject.getString("priceName"));
                    price.setMaterialSpec(detailObject.getString("priceSpec"));
                    price.setPriceUnit(detailObject.getString("priceUnit"));
                    price.setPriceDate(new Date());
                }
                price.setCategoryName(detailObject.getString("priceName"));
                price.setPriceRange(detailObject.getString("priceNumber"));
                price.setPriceType(AsianMetalTypeEnum.getByValue(detailObject.getString("priceType")));
                price.setElsAccount(elsAccount);
                price.setId(null);
                bulkMaterialPriceList.add(price);
            }
        }
        if (bulkMaterialPriceList != null && bulkMaterialPriceList.size() > 0) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"price_date", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            wrapper.eq((Object)"els_account", (Object)elsAccount);
            wrapper.eq((Object)"source_system", (Object)"\u4e9a\u6d32\u91d1\u5c5e\u7f51");
            this.bulkMaterialPriceService.remove((Wrapper)wrapper);
            this.bulkMaterialPriceService.saveBatch(bulkMaterialPriceList);
        }
    }

    public JSONArray judugeResult(JSONObject object) {
        JSONObject data;
        if (CommonConstant.SC_OK_200 == object.getInteger("code") && "200".equals((data = object.getJSONObject("data")).getString("code")) && StringUtils.isNotBlank((CharSequence)data.getString("result"))) {
            return data.getJSONArray("result");
        }
        return null;
    }
}

