/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.mapper.PurchaseMaterialHeadMapper;
import com.els.modules.material.mapper.PurchaseMaterialItemMapper;
import com.els.modules.material.mapper.PurchaseMaterialUnitMapper;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialHeadServiceImpl
extends ServiceImpl<PurchaseMaterialHeadMapper, PurchaseMaterialHead>
implements PurchaseMaterialHeadService {
    @Resource
    private PurchaseMaterialHeadMapper purchaseMaterialHeadMapper;
    @Resource
    private PurchaseMaterialItemMapper purchaseMaterialItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialUnitMapper purchaseMaterialUnitMapper;
    @Resource
    private InterfaceUtil interfaceUtil;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseMaterialHead purchaseMaterialHead, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        this.checkMaterialNumber(purchaseMaterialHead);
        for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
            if (PURCHASE_UNIT_TYPE.equals(unit.getType()) && PURCHASE_UNIT_TYPE.equals(unit.getIsDefault())) {
                purchaseMaterialHead.setPurchaseUnit(unit.getObjectUnit());
                continue;
            }
            if (!REPERTORY_UNIT_TYPE.equals(unit.getType()) || !PURCHASE_UNIT_TYPE.equals(unit.getIsDefault())) continue;
            purchaseMaterialHead.setRepertoryUnit(unit.getObjectUnit());
        }
        this.purchaseMaterialHeadMapper.insert((Object)purchaseMaterialHead);
        this.insertData(purchaseMaterialHead, purchaseMaterialItemList, purchaseMaterialUnitList);
    }

    private void checkMaterialNumber(PurchaseMaterialHead purchaseMaterialHead) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)purchaseMaterialHead.getMaterialNumber())).ne(StrUtil.isNotBlank((CharSequence)purchaseMaterialHead.getId()), BaseEntity::getId, (Object)purchaseMaterialHead.getId())).last(" limit 1");
        PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)((PurchaseMaterialHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (null != head) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_MKdejSLAyWWWWWW_fe5429fb", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u7f16\u53f7\uff1a" + purchaseMaterialHead.getMaterialNumber()), (String[])new String[]{purchaseMaterialHead.getMaterialNumber()}));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMaterialHead purchaseMaterialHead, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        if (REPERTORY_UNIT_TYPE.equals(purchaseMaterialHead.getAutoCreateCode()) && StrUtil.isBlank((CharSequence)purchaseMaterialHead.getMaterialNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmMaterialNumber", (Object)purchaseMaterialHead);
            purchaseMaterialHead.setMaterialNumber(nextCode);
        } else if (StrUtil.isBlank((CharSequence)purchaseMaterialHead.getMaterialNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoxOLVW_47edf9d6", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        this.checkMaterialNumber(purchaseMaterialHead);
        for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
            if (PURCHASE_UNIT_TYPE.equals(unit.getType()) && PURCHASE_UNIT_TYPE.equals(unit.getIsDefault())) {
                purchaseMaterialHead.setPurchaseUnit(unit.getObjectUnit());
                continue;
            }
            if (!REPERTORY_UNIT_TYPE.equals(unit.getType()) || !PURCHASE_UNIT_TYPE.equals(unit.getIsDefault())) continue;
            purchaseMaterialHead.setRepertoryUnit(unit.getObjectUnit());
        }
        int count = this.purchaseMaterialHeadMapper.updateById((Object)purchaseMaterialHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseMaterialItemMapper.deleteByMainId(purchaseMaterialHead.getId());
        this.purchaseMaterialUnitMapper.deleteByMainId(purchaseMaterialHead.getId());
        this.insertData(purchaseMaterialHead, purchaseMaterialItemList, purchaseMaterialUnitList);
    }

    private void insertData(PurchaseMaterialHead purchaseMaterialHead, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        if (CollectionUtil.isNotEmpty(purchaseMaterialItemList)) {
            for (PurchaseMaterialItem entity : purchaseMaterialItemList) {
                entity.setHeadId(purchaseMaterialHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseMaterialHead);
            }
            ((PurchaseMaterialItemService)SpringContextUtils.getBean(PurchaseMaterialItemService.class)).saveBatch(purchaseMaterialItemList);
        }
        if (CollectionUtil.isNotEmpty(purchaseMaterialUnitList)) {
            for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
                unit.setHeadId(purchaseMaterialHead.getId());
                unit.setElsAccount(purchaseMaterialHead.getElsAccount());
                SysUtil.setSysParam((BaseEntity)unit, (BaseEntity)purchaseMaterialHead);
            }
            ((PurchaseMaterialUnitService)SpringContextUtils.getBean(PurchaseMaterialUnitService.class)).saveBatch(purchaseMaterialUnitList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseMaterialItemMapper.deleteByMainId(id);
        this.purchaseMaterialHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delHead(String id) {
        this.purchaseMaterialItemMapper.updateByHeadId(id);
        this.purchaseMaterialHeadMapper.updateByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseMaterialItemMapper.deleteByMainId(serializable.toString());
            this.purchaseMaterialHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public PurchaseMaterialHead getMaterialHeadByNumber(String materialNumber) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)materialNumber);
        List materialList = this.list((Wrapper)wrapper);
        return materialList.isEmpty() ? null : (PurchaseMaterialHead)((Object)materialList.get(0));
    }

    @Override
    public List<PurchaseMaterialHead> getMaterialHeadByNumbers(List<String> materialNumbers) {
        if (CollUtil.isEmpty(materialNumbers)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PurchaseMaterialHead::getMaterialNumber, materialNumbers);
        return ((PurchaseMaterialHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public PurchaseMaterialHead queryMaterialItemByFactory(PurchaseMaterialHead purchaseMaterialHeadPage) {
        List purchaseMaterialItemList;
        LambdaQueryWrapper purchaseMaterialHeadLambdaQueryWrapper = new LambdaQueryWrapper();
        purchaseMaterialHeadLambdaQueryWrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)purchaseMaterialHeadPage.getMaterialNumber());
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadMapper.selectOne((Wrapper)purchaseMaterialHeadLambdaQueryWrapper));
        List<PurchaseMaterialItem> materialItemList = this.purchaseMaterialItemMapper.selectByMainId(purchaseMaterialHead.getId());
        if (CollectionUtil.isNotEmpty(materialItemList) && CollectionUtil.isNotEmpty(purchaseMaterialItemList = materialItemList.stream().filter(item -> purchaseMaterialHeadPage.getFactory().equals(item.getFactory())).collect(Collectors.toList()))) {
            PurchaseMaterialItem purchaseMaterialItem = (PurchaseMaterialItem)((Object)purchaseMaterialItemList.get(0));
            purchaseMaterialHead.setJit(purchaseMaterialItem.getJit());
        }
        return purchaseMaterialHead;
    }

    @Override
    public void getDataByErp(PurchaseMaterialHead materialHead) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getMaterialData", (Object)new JSONObject());
    }

    @Override
    public void pushMaterialByManual(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List materialList = this.listByIds(idList).stream().filter(head -> !REPERTORY_UNIT_TYPE.equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseMaterialHead head2 : materialList) {
            this.pushMaterial(head2);
        }
    }

    @Override
    public void pushMaterial(PurchaseMaterialHead head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushMaterialToERP", (Object)head);
    }
}

