/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirddata.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.thirddata.entity.BulkMaterialPrice;
import com.els.modules.thirddata.service.BulkMaterialPriceService;
import com.els.modules.thirddata.service.ScanWebSiteService;
import com.els.modules.thirddata.vo.ScanWebSiteVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u5b97\u6750\u6599\u4ef7\u683c"})
@RestController
@RequestMapping(value={"/thirddata/bulkMaterialPrice"})
public class BulkMaterialPriceController
extends BaseController<BulkMaterialPrice, BulkMaterialPriceService> {
    @Resource
    private BulkMaterialPriceService bulkMaterialPriceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(BulkMaterialPrice bulkMaterialPrice, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)bulkMaterialPrice), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.bulkMaterialPriceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5927\u5b97\u6750\u6599\u4ef7\u683c-\u6293\u53d6\u6570\u636e")
    @ApiOperation(value="\u6293\u53d6\u6570\u636e", notes="\u6293\u53d6\u6570\u636e")
    @PostMapping(value={"/scan"})
    public Result<?> add(@RequestBody ScanWebSiteVO scanWebSiteVO) {
        ScanWebSiteService scanWebSiteService = (ScanWebSiteService)SpringContextUtils.getBean((String)scanWebSiteVO.getBeanName());
        scanWebSiteService.execute(scanWebSiteVO.getScanUrl());
        return Result.ok((Object)scanWebSiteVO);
    }

    @RequestMapping(value={"/matalType"}, method={RequestMethod.POST})
    public Result<?> saveData(@RequestBody JSONObject jsonObjectVal) {
        String beanName = jsonObjectVal.getString("beanName");
        JSONObject dataVal = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("priceSource", (Object)beanName);
        jsonObject.put("language", (Object)"1");
        JSONObject result = this.bulkMaterialPriceService.callIPaasInterface(jsonObject, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getAsianmetalPrice"));
        JSONObject data = result.getJSONObject("data");
        JSONArray jsonArray = data.getJSONArray("result");
        JSONObject metalPriceVal = new JSONObject();
        metalPriceVal.put("priceSource", (Object)beanName);
        metalPriceVal.put("language", (Object)"1");
        JSONObject resultGetAsianmetalSpecificationDetail = this.bulkMaterialPriceService.callIPaasInterface(metalPriceVal, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getAsianmetalSpecificationDetail"));
        JSONArray data1 = resultGetAsianmetalSpecificationDetail.getJSONObject("data").getJSONArray("result");
        ArrayList<BulkMaterialPrice> bulkMaterialPrices = new ArrayList<BulkMaterialPrice>();
        for (int i = 0; i < data1.size(); ++i) {
            BulkMaterialPrice bulkMaterialPrice = new BulkMaterialPrice();
            HashMap hashMap1 = new HashMap();
            bulkMaterialPrice.setCategoryName(data1.getJSONObject(i).getString("product"));
            bulkMaterialPrice.setMaterialSpec(data1.getJSONObject(i).getString("from"));
            bulkMaterialPrice.setSize(data1.getJSONObject(i).getString("size"));
            bulkMaterialPrice.setPacking(data1.getJSONObject(i).getString("packing"));
            bulkMaterialPrice.setMakeAddr(data1.getJSONObject(i).getString("origin"));
            bulkMaterialPrice.setPriceSource(data1.getJSONObject(i).getString("basis"));
            bulkMaterialPrice.setPayment(data1.getJSONObject(i).getString("payment"));
            bulkMaterialPrice.setTax(data1.getJSONObject(i).getString("tax"));
            bulkMaterialPrice.setDuty(data1.getJSONObject(i).getString("duty"));
            bulkMaterialPrice.setShipment(data1.getJSONObject(i).getString("shipment"));
            bulkMaterialPrice.setDeliveryAddr(data1.getJSONObject(i).getString("location"));
            bulkMaterialPrice.setLot(data1.getJSONObject(i).getString("lot"));
            bulkMaterialPrice.setCurrency(data1.getJSONObject(i).getString("currency"));
            bulkMaterialPrice.setPriceUnit(data1.getJSONObject(i).getString("unit"));
            bulkMaterialPrice.setUseType(data1.getJSONObject(i).getString("assessment"));
            bulkMaterialPrice.setMaterialSpec(data1.getJSONObject(i).getString("specification"));
            bulkMaterialPrices.add(bulkMaterialPrice);
        }
        this.bulkMaterialPriceService.saveBatch(bulkMaterialPrices, 1000);
        return Result.ok((Object)data1);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"bulkMaterialPrice:getDataByErp"})
    public Result<?> getDataByErp() {
        this.bulkMaterialPriceService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"bulkMaterialPrice:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.bulkMaterialPriceService.pushDataToErp(ids);
        return Result.ok();
    }
}

