/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.mapper.PurchaseBomHeadMapper;
import com.els.modules.material.mapper.PurchaseBomItemMapper;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBomHeadServiceImpl
extends ServiceImpl<PurchaseBomHeadMapper, PurchaseBomHead>
implements PurchaseBomHeadService {
    @Resource
    private PurchaseBomHeadMapper purchaseBomHeadMapper;
    @Resource
    private PurchaseBomItemMapper purchaseBomItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InterfaceUtil interfaceUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        if ("0".equals(purchaseBomHead.getNeedAudit())) {
            purchaseBomHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchaseBomHead.setBomNumber(this.invokeBaseRpcService.getNextCode("bomNumber", (Object)purchaseBomHead));
        this.purchaseBomHeadMapper.insert((Object)purchaseBomHead);
        this.insertData(purchaseBomHead, purchaseBomItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        boolean flag;
        if (StrUtil.isNotBlank((CharSequence)purchaseBomHead.getVersion())) {
            try {
                if (Integer.parseInt(purchaseBomHead.getVersion()) <= 0) {
                    purchaseBomHead.setVersion("1");
                }
            }
            catch (Exception e) {
                purchaseBomHead.setVersion("1");
            }
        }
        boolean bl = flag = null != purchaseBomHead.getEffectiveDate() && null != purchaseBomHead.getExpiryDate() && purchaseBomHead.getExpiryDate().before(purchaseBomHead.getEffectiveDate());
        if (flag) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PurchaseBomHead::getMaterialNumber, (Object)purchaseBomHead.getMaterialNumber())).eq(PurchaseBomHead::getFactory, (Object)purchaseBomHead.getFactory())).eq(PurchaseBomHead::getVersion, (Object)purchaseBomHead.getVersion())).ne(BaseEntity::getId, (Object)purchaseBomHead.getId())).last("limit 1");
        PurchaseBomHead bomHead = (PurchaseBomHead)((Object)((PurchaseBomHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        Assert.isTrue((null == bomHead || bomHead.getId().equals(purchaseBomHead.getId()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWWWtFIOMK_2f383a6c", (String)"\u5f53\u524dBOM\u5355\u636e\u5df2\u7ecf\u5b58\u5728"));
        if ("0".equals(purchaseBomHead.getNeedAudit())) {
            purchaseBomHead.setAuditStatus("");
        }
        purchaseBomHead.setBomStatus(PurchaseBomStatus.NORMAL.getValue());
        int count = this.purchaseBomHeadMapper.updateById((Object)purchaseBomHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBomItemMapper.deleteByMainId(purchaseBomHead.getId());
        this.insertData(purchaseBomHead, purchaseBomItemList);
    }

    private List<PurchaseBomItem> buildTree(List<PurchaseBomItem> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        for (PurchaseBomItem item : all) {
            item.setChildren(this.getChildren(item, all));
            if (!rootId.equals(item.getParentMaterialNumber()) || item.getMaterialNumber().equals(item.getParentMaterialNumber())) continue;
            parent.add(item);
        }
        return parent;
    }

    private List<PurchaseBomItem> getChildren(PurchaseBomItem bom, List<PurchaseBomItem> all) {
        ArrayList<PurchaseBomItem> childList = new ArrayList<PurchaseBomItem>(8);
        for (PurchaseBomItem child : all) {
            if (!bom.getMaterialNumber().equals(child.getParentMaterialNumber()) || bom.getMaterialNumber().equals(bom.getParentMaterialNumber())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    private void insertData(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        if (CollectionUtil.isNotEmpty(purchaseBomItemList)) {
            for (PurchaseBomItem entity : purchaseBomItemList) {
                entity.setMaterialOrder(StrUtil.emptyToDefault((CharSequence)entity.getMaterialOrder(), (String)"1"));
                entity.setParentMaterialNumber(StrUtil.emptyToDefault((CharSequence)entity.getParentMaterialNumber(), (String)""));
            }
            List<PurchaseBomItem> itemsTree = this.buildTree(purchaseBomItemList, "");
            this.sort(itemsTree);
            List<PurchaseBomItem> resultList = this.recursionTreeToList(itemsTree, null);
            int i = 1;
            for (PurchaseBomItem entity : resultList) {
                entity.setItemNumber(Integer.toString(i));
                entity.setHeadId(purchaseBomHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBomHead);
                entity.setId(IdWorker.getIdStr());
                ++i;
            }
            ((PurchaseBomItemService)SpringContextUtils.getBean(PurchaseBomItemService.class)).saveBatch(resultList);
        }
    }

    public List<PurchaseBomItem> recursionTreeToList(List<PurchaseBomItem> tree, List<PurchaseBomItem> result) {
        if (null == result) {
            result = new ArrayList<PurchaseBomItem>();
        }
        for (PurchaseBomItem item : tree) {
            result.add(item);
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            this.recursionTreeToList(item.getChildren(), result);
        }
        return result;
    }

    private void sort(List<PurchaseBomItem> itemsTree) {
        if (CollUtil.isNotEmpty(itemsTree)) {
            itemsTree.sort(Comparator.comparingDouble(x -> Double.parseDouble(x.getMaterialOrder())));
        }
        for (PurchaseBomItem item : itemsTree) {
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            this.sort(item.getChildren());
        }
    }

    @Override
    public void frozenBom(String id) {
        this.purchaseBomHeadMapper.frozenBom(id);
    }

    @Override
    public void thawBom(String id) {
        this.purchaseBomHeadMapper.thawBom(id);
    }

    @Override
    public void cancelBom(String id) {
        this.purchaseBomHeadMapper.cancelBom(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBomItemMapper.deleteByMainId(id);
        this.purchaseBomHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.purchaseBomItemMapper.deleteByMainIds(idList);
        ((PurchaseBomHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseBom", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List bomHeadList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseBomHead head2 : bomHeadList) {
            this.pushDataToErp(head2);
        }
    }

    @Override
    public Map<String, PurchaseBomHead> listBomByBomNumber(List<String> bomNumberList, String elsAccount) {
        if (CollUtil.isEmpty(bomNumberList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(PurchaseBomHead::getBomNumber, bomNumberList);
        wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseBomHead::getBomNumber, PurchaseBomHead::getNeedAudit, PurchaseBomHead::getAuditStatus, PurchaseBomHead::getBomStatus});
        List purchaseBomHeads = ((PurchaseBomHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return purchaseBomHeads.stream().collect(Collectors.toMap(PurchaseBomHead::getBomNumber, Function.identity(), (v1, v2) -> v2));
    }

    private void pushDataToErp(PurchaseBomHead head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseBom", (Object)head);
    }
}

