/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasePriceCreateServiceImpl")
public class PurchasePriceCreateServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseInformationRecords> headList = new ArrayList<PurchaseInformationRecords>();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseInformationRecords head = (PurchaseInformationRecords)((Object)JSON.parseObject((String)object.toString(), PurchaseInformationRecords.class));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setCreateBy("interface");
            head.setUpdateBy("interface");
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)head), (String[])new String[0]);
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            head.setSourceSystem(PriceSourceTypeEnum.OTHER.getValue());
            head.setBusAccount(head.getElsAccount());
            head.setRecordStatus(PriceStatusEnum.NEW.getValue());
            headList.add(head);
        }
        this.purchaseInformationRecordsService.saveBatch(headList);
        return null;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "price";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseInformationRecords.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"itemList"});
    }
}

