/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.DateUtils;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.extend.api.service.UploadFileForErpService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.enumerate.OperationTypeEnum;
import com.els.modules.material.enumerate.PurchaseAttachmentDisableEnum;
import com.els.modules.material.mapper.PurchaseMaterialItemMapper;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SynPurchaseMaterialServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(SynPurchaseMaterialServiceImpl.class);
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private PurchaseMaterialItemMapper purchaseMaterialItemMapper;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private UploadFileForErpService uploadFileForErpService;
    @Value(value="${els.config.purchaseAccount}")
    private String purchaseAccount;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public JSONObject invoke(JSONObject jsonObject) {
        log.info("ERP\u540c\u6b65\u7269\u6599\u4e3b\u6570\u636e\u63a5\u53e3\u5f00\u59cb\uff1a" + DateUtils.formatDateTime() + "\u5165\u53c2\uff1a" + jsonObject.toJSONString());
        if (null == jsonObject || jsonObject.isEmpty()) {
            log.error("ERP\u540c\u6b65\u7269\u6599\u4e3b\u6570\u636e\u53c2\u6570\u4e3a\u7a7a;");
            return JSONObject.parseObject((String)JSONObject.toJSONString((Object)Result.error((String)"\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a\uff0c\u540c\u6b65\u5931\u8d25;")));
        }
        JSONArray array = jsonObject.getJSONArray("headList");
        TemplateHead templateHead = this.templateHeadService.getDefaultOneTemplateByType("material");
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)JSON.parseObject((String)object.toString(), PurchaseMaterialHead.class));
            Assert.hasText((String)head.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)head.getMaterialNumber(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            PurchaseMaterialHead oldMaterialHead = this.purchaseMaterialHeadService.getMaterialHeadByNumber(head.getMaterialNumber());
            if (OperationTypeEnum.CREATE.getValue().equals(head.getOperationType()) || OperationTypeEnum.UPDATE.getValue().equals(head.getOperationType())) {
                this.createMaterial(head, object, templateHead, oldMaterialHead);
            }
            if (!OperationTypeEnum.DELETE.getValue().equals(head.getOperationType())) continue;
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(PurchaseMaterialHead::getMaterialNumber, (Object)head.getMaterialNumber())).eq(BaseEntity::getElsAccount, (Object)this.purchaseAccount)).set(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_1);
            this.purchaseMaterialHeadService.update((Wrapper)updateWrapper);
        }
        return null;
    }

    private void createMaterial(PurchaseMaterialHead head, JSONObject object, TemplateHead templateHead, PurchaseMaterialHead oldMaterialHead) {
        this.checkHeadRequired(head);
        head = this.initHead(head, templateHead);
        ArrayList<PurchaseAttachment> oldpurchaseAttachment = new ArrayList();
        if (null != oldMaterialHead) {
            oldpurchaseAttachment = this.purchaseAttachmentService.selectByMainId(oldMaterialHead.getId());
            head.setId(oldMaterialHead.getId());
        }
        List<Object> itemList = new ArrayList();
        JSONArray itemListJsonArray = object.getJSONArray("itemList");
        try {
            if (null == itemListJsonArray || itemListJsonArray.isEmpty()) {
                throw new ELSBootException("\u7269\u6599\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            itemList = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseMaterialItem.class);
            this.checkItemRequired(itemList);
            itemList = this.initItemList(itemList, head);
        }
        catch (Exception e) {
            log.error("{}==>ItemList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)"material", (Object)e.getMessage());
            throw new ELSBootException("\u7269\u6599\u884c\u4fe1\u606f\u6709\u8bef\uff1a" + e.getMessage());
        }
        List<Object> attachmentList = new ArrayList();
        JSONArray attachmentListJsonArray = object.getJSONArray("attachmentList");
        if (null != attachmentListJsonArray && !attachmentListJsonArray.isEmpty()) {
            attachmentList = JSON.parseArray((String)attachmentListJsonArray.toJSONString(), PurchaseAttachment.class);
            this.checkAttachmentRequired(attachmentList);
            attachmentList = this.initAttachmentList(attachmentList, head, oldpurchaseAttachment);
        }
        if (null != oldMaterialHead) {
            this.purchaseMaterialHeadService.updateById((Object)head);
            this.purchaseMaterialItemMapper.deleteByMainId(head.getId());
        } else {
            this.purchaseMaterialHeadService.save((Object)head);
        }
        this.purchaseMaterialItemService.saveBatch(itemList);
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.purchaseAttachmentService.saveBatch(attachmentList);
        }
        if (CollectionUtil.isNotEmpty(oldpurchaseAttachment)) {
            oldpurchaseAttachment.forEach(item -> item.setFbk1(PurchaseAttachmentDisableEnum.FREEZE.getDesc()));
            this.purchaseAttachmentService.updateBatchById(oldpurchaseAttachment);
        }
        this.purchaseMaterialHeadService.getDataByErp(head);
    }

    private PurchaseMaterialHead initHead(PurchaseMaterialHead head, TemplateHead templateHead) {
        head.setElsAccount(this.purchaseAccount);
        head.setCreateTime(new Date());
        head.setCreateBy("interface");
        head.setUpdateBy(head.getCreateBy());
        head.setId(SysUtil.getAssignId((Object)((Object)head)));
        head.setSourceType("erp");
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setTemplateAccount(templateHead.getElsAccount());
        head.setTemplateName(templateHead.getTemplateName());
        head.setTemplateNumber(templateHead.getTemplateNumber());
        head.setTemplateVersion(templateHead.getTemplateVersion());
        head.setMaterialDesc(head.getMaterialName());
        head.setPurchasePriceUnitId(head.getFbk6());
        return head;
    }

    private List<PurchaseAttachment> initAttachmentList(List<PurchaseAttachment> attachmentList, PurchaseMaterialHead head, List<PurchaseAttachment> oldpurchaseAttachment) {
        int size = oldpurchaseAttachment.size();
        for (PurchaseAttachment attachment : attachmentList) {
            ++size;
            attachment.setId(SysUtil.getAssignId((Object)attachment));
            attachment.setHeadId(head.getId());
            attachment.setElsAccount(this.purchaseAccount);
            attachment.setSendStatus("1");
            attachment.setBusinessType("material");
            attachment.setSaveType("local");
            attachment.setItemNumber(String.valueOf(size));
            attachment.setFilePath(this.uploadFileForErpService.uploadFile(attachment.getActionRoutePath()));
            attachment.setFbk2(String.valueOf(size));
            attachment.setSourceType("2");
            attachment.setCreateTime(new Date());
            attachment.setUpdateTime(new Date());
            attachment.setFbk1(PurchaseAttachmentDisableEnum.ENABLE.getDesc());
        }
        return attachmentList;
    }

    private List<PurchaseMaterialItem> initItemList(List<PurchaseMaterialItem> itemList, PurchaseMaterialHead head) {
        for (PurchaseMaterialItem item : itemList) {
            item.setId(SysUtil.getAssignId((Object)((Object)item)));
            item.setHeadId(head.getId());
            item.setElsAccount(this.purchaseAccount);
            item.setCreateTime(new Date());
        }
        return itemList;
    }

    private void checkAttachmentRequired(List<PurchaseAttachment> attachmentList) {
        attachmentList.forEach(item -> {
            Assert.hasText((String)item.getFileName(), (String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)item.getUploadTime(), (String)"\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)item.getActionRoutePath(), (String)"\u8d85\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    private void checkItemRequired(List<PurchaseMaterialItem> itemList) {
        itemList.forEach(item -> {
            Assert.hasText((String)item.getMaterialNumber(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)item.getFactory(), (String)"\u5de5\u5382\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    private void checkHeadRequired(PurchaseMaterialHead head) {
        Assert.hasText((String)head.getMaterialName(), (String)"\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getCateCode(), (String)"\u7269\u6599\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getCateName(), (String)"\u7269\u6599\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getPurchaseType(), (String)"\u91c7\u8d2d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getCheckWay(), (String)"\u68c0\u9a8c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getBaseUnit(), (String)"\u57fa\u672c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getFbk1(), (String)"\u7ec4\u7ec7\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getPurchaseOrg(), (String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getFreeze(), (String)"\u662f\u5426\u51bb\u7ed3\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getFbk2(), (String)"\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)head.getPurchaseUnit(), (String)"\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

