/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.material.entity.PurchaseAttachmentExtDTO;
import com.els.modules.material.enumerate.PurchaseAttachmentDisableEnum;
import com.els.modules.material.service.PurchaseAttachmentExtDTOService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/attachmentApi/purchaseAttachmentExtDTO"})
@Api(tags={"\u91c7\u8d2d\u9644\u4ef6"})
public class PurchaseAttachmentExtDTOController
extends BaseController<PurchaseAttachmentExtDTO, PurchaseAttachmentExtDTOService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAttachmentExtDTOController.class);
    @Autowired
    private PurchaseAttachmentExtDTOService purchaseAttachmentExtDTOService;
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseAttachmentExtDTO purchaseAttachmentExtDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseAttachmentExtDTO), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseAttachmentExtDTOService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response, HttpServletRequest request) {
        PurchaseAttachmentExtDTO attachment = (PurchaseAttachmentExtDTO)((Object)this.purchaseAttachmentExtDTOService.getById((Serializable)((Object)id)));
        try {
            this.headBuilder(response, request, attachment.getFileName());
            this.purchaseAttachmentExtDTOService.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
        }
        catch (Exception var6) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + var6.getMessage());
        }
    }

    private void headBuilder(HttpServletResponse response, HttpServletRequest request, String filename) throws Exception {
        filename = request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(filename, "UTF-8") : new String(filename.getBytes("UTF-8"), "ISO8859-1");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
        response.setContentType("application/octet-stream");
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        Assert.hasText((String)businessType, (String)I18nUtil.translate((String)"i18n_alert_RRESAc_50983d0e", (String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b"));
        String headId = request.getParameter("headId");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a"));
        String itemNumber = request.getParameter("itemNumber");
        String fileType = request.getParameter("fileType");
        String materialNumber = request.getParameter("materialNumber");
        String materialName = request.getParameter("materialName");
        String attachmentVersion = request.getParameter("attachmentVersion");
        String effectiveDate = request.getParameter("effectiveDate");
        String expiryDate = request.getParameter("expiryDate");
        String sourceNumber = request.getParameter("sourceNumber");
        String actionRoutePath = request.getParameter("actionRoutePath");
        String saveType = request.getParameter("saveType");
        String caType = request.getParameter("caType");
        String elsAccount = this.getTenantId();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            List<PurchaseAttachmentExtDTO> purchaseAttachments = this.purchaseAttachmentExtDTOService.selectByHeadId(headId);
            this.purchaseAttachmentExtDTOService.updateByHeadId(headId);
            int i = 0;
            if (!CollectionUtils.isEmpty(purchaseAttachments)) {
                i = purchaseAttachments.size();
            }
            for (Map.Entry entity : fileMap.entrySet()) {
                boolean result;
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                StorageFileInfo fileInfo = this.fileStoreSignServiceImpl.storeFile(uploadFile, (String)null, saveType, caType);
                PurchaseAttachment attachment = new PurchaseAttachment();
                if (StringUtils.isNotBlank((CharSequence)fileInfo.getId())) {
                    attachment.setId(fileInfo.getId());
                }
                attachment.setBusinessType(businessType);
                attachment.setHeadId(headId);
                attachment.setItemNumber(itemNumber);
                if (CharSequenceUtil.isEmpty((CharSequence)fileType)) {
                    fileType = "5";
                }
                attachment.setFbk1(PurchaseAttachmentDisableEnum.ENABLE.getDesc());
                attachment.setFbk2(String.valueOf(++i));
                attachment.setFileType(fileType);
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(elsAccount);
                attachment.setFileName(uploadFile.getOriginalFilename());
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(fileInfo.getPath());
                attachment.setSaveType(fileInfo.getSaveType());
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                attachment.setMaterialName(materialName);
                attachment.setMaterialNumber(materialNumber);
                attachment.setSourceType("1");
                attachment.setAttachmentVersion(attachmentVersion);
                attachment.setActionRoutePath(actionRoutePath);
                attachment.setSourceNumber(sourceNumber);
                try {
                    attachment.setEffectiveDate((Date)DateUtil.parseDate((CharSequence)effectiveDate));
                    attachment.setExpiryDate((Date)DateUtil.parseDate((CharSequence)expiryDate));
                }
                catch (Exception var24) {
                    log.error("\u65e5\u671f\u8f6c\u5316\u5931\u8d25\uff1a\u3010expiryDate-" + effectiveDate + "\u3011\uff0c\u3010expiryDate-" + expiryDate + "\u3011");
                }
                if (!(result = this.purchaseAttachmentService.save((Object)attachment))) continue;
                attachment.setAbsoluteFilePath(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), attachment.getSaveType()));
                return Result.ok((Object)attachment);
            }
        }
        catch (Exception var25) {
            log.error(var25.getMessage(), (Throwable)var25);
            return Result.error((String)var25.getMessage());
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }
}

