/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.enumerate.PurchaseAttachmentDisableEnum;
import com.els.modules.material.excel.PurchaseMaterialHeadExportServiceImpl;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/material/purchaseMaterialHead"})
@Api(tags={"\u7269\u6599\u4e3b\u6570\u636e\u5934"})
public class PurchaseMaterialHeadController
extends BaseController<PurchaseMaterialHead, PurchaseMaterialHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialHeadController.class);
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Autowired
    private PurchaseMaterialUnitService purchaseMaterialUnitService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/page-list"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:list"})
    @PermissionDataView(businessType="material")
    public Result<?> pageList(PurchaseMaterialHead purchaseMaterialHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialHead), (Map)req.getParameterMap());
        queryWrapper.lambda().and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseMaterialHead::getBlocDel)).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseMaterialHead::getBlocDel, (Object)"");
            })).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseMaterialHead::getBlocDel, (Object)"0");
            });
        });
        queryWrapper.lambda().and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(PurchaseMaterialHead::getAuditStatus, (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseMaterialHead::getAuditStatus, (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            });
        });
        String[] filterPurchaseTypes = (String[])req.getParameterMap().get("filterPurchaseType");
        if (null != filterPurchaseTypes && filterPurchaseTypes.length > 0) {
            ArrayList filterPurchaseType = Lists.newArrayList((Object[])filterPurchaseTypes[0].split(","));
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.notIn(PurchaseMaterialHead::getPurchaseType, (Collection)filterPurchaseType)).or()).isNull(PurchaseMaterialHead::getPurchaseType);
            });
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMaterialHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:list"})
    @PermissionDataView(businessType="material")
    public Result<?> queryPageList(PurchaseMaterialHead purchaseMaterialHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialHead), (Map)req.getParameterMap());
        String[] filterPurchaseTypes = (String[])req.getParameterMap().get("filterPurchaseType");
        if (null != filterPurchaseTypes && filterPurchaseTypes.length > 0) {
            ArrayList filterPurchaseType = Lists.newArrayList((Object[])filterPurchaseTypes[0].split(","));
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.notIn(PurchaseMaterialHead::getPurchaseType, (Collection)filterPurchaseType)).or()).isNull(PurchaseMaterialHead::getPurchaseType);
            });
        }
        queryWrapper.lambda().eq(PurchaseMaterialHead::getBlocDel, (Object)"0");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMaterialHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/page"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:list"})
    @PermissionDataView(businessType="material")
    public Result<?> page(PurchaseMaterialHead purchaseMaterialHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialHead), (Map)req.getParameterMap());
        String[] filterPurchaseTypes = (String[])req.getParameterMap().get("filterPurchaseType");
        if (null != filterPurchaseTypes && filterPurchaseTypes.length > 0) {
            ArrayList filterPurchaseType = Lists.newArrayList((Object[])filterPurchaseTypes[0].split(","));
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.notIn(PurchaseMaterialHead::getPurchaseType, (Collection)filterPurchaseType)).or()).isNull(PurchaseMaterialHead::getPurchaseType);
            });
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMaterialHeadService.page((IPage)page, (Wrapper)queryWrapper);
        try {
            pageList.getRecords().stream().filter(h -> StrUtil.isBlank((CharSequence)h.getFbk8())).forEach(this.purchaseMaterialHeadService::getDataByErp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8ba1\u7b97\u5355\u67e5\u8be2\u7269\u6599\u5206\u9875\u5217\u8868", notes="\u8ba1\u7b97\u5355\u67e5\u8be2\u7269\u6599\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/queryPageListByCalculation"})
    public Result<?> queryPageListByCalculation(PurchaseMaterialHead purchaseMaterialHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String[] filterPurchaseTypes = (String[])req.getParameterMap().get("ids");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialHead), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaseMaterialHead::getBlocDel, (Object)"0")).in(PurchaseMaterialHead::getAuditStatus, new Object[]{AuditStatusEnum.AUDIT_FINISH.getValue(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()})).eq(PurchaseMaterialHead::getSubmitStatus, (Object)"1");
        if (null != filterPurchaseTypes && filterPurchaseTypes.length > 0 && !StringUtils.isEmpty((String)filterPurchaseTypes[0])) {
            ArrayList filterPurchaseType = Lists.newArrayList((Object[])filterPurchaseTypes[0].split(","));
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.in(BaseEntity::getId, (Collection)filterPurchaseType);
            });
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMaterialHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2\u7269\u6599\u5934\u6216\u8005\u884c", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2\u7269\u6599\u5934\u6216\u8005\u884c")
    @GetMapping(value={"/list-head-or-item"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:list"})
    @PermissionDataView(businessType="material")
    public Result<?> queryPageListHeadOrItem(PurchaseMaterialHeadVO purchaseMaterialHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialHead), (Map)req.getParameterMap());
        String[] filterPurchaseTypes = (String[])req.getParameterMap().get("filterPurchaseType");
        if (null != filterPurchaseTypes && filterPurchaseTypes.length > 0) {
            ArrayList filterPurchaseType = Lists.newArrayList((Object[])filterPurchaseTypes[0].split(","));
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.notIn(PurchaseMaterialHead::getPurchaseType, (Collection)filterPurchaseType)).or()).isNull(PurchaseMaterialHead::getPurchaseType);
            });
        }
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchaseMaterialHead> pageList = this.purchaseMaterialHeadService.pageHeadOrItem((Page<PurchaseMaterialHead>)page, (QueryWrapper<PurchaseMaterialHead>)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6839\u636e\u5de5\u5382\u8054\u67e5\u5934\u884c\u4fe1\u606f", notes="\u6839\u636e\u5de5\u5382\u8054\u67e5\u5934\u884c\u4fe1\u606f")
    @GetMapping(value={"/listHeadAndItemByFactory"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:list"})
    @PermissionDataView(businessType="material")
    public Result<?> listHeadAndItemByFactory(PurchaseMaterialHeadVO purchaseMaterialHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<?> result = this.queryPageList(purchaseMaterialHead, pageNo, pageSize, req);
        Object materialHeadListObj = result.getResult();
        IPage materialHeadListPage = (IPage)materialHeadListObj;
        List records = materialHeadListPage.getRecords();
        ArrayList<String> ids = new ArrayList<String>();
        for (PurchaseMaterialHead materialHead : records) {
            if (!StringUtils.isNotBlank((String)materialHead.getFactory())) continue;
            ids.add(materialHead.getId());
        }
        if (CollectionUtil.isNotEmpty(ids)) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(PurchaseMaterialItem::getHeadId, ids);
            List materialItemList = this.purchaseMaterialItemService.list((Wrapper)lambdaQueryWrapper);
            HashMap<String, PurchaseMaterialItem> materialItemMap = new HashMap<String, PurchaseMaterialItem>();
            if (CollectionUtil.isNotEmpty((Collection)materialItemList)) {
                for (PurchaseMaterialItem materialItem : materialItemList) {
                    materialItemMap.put(materialItem.getHeadId() + "&" + materialItem.getFactory(), materialItem);
                }
            }
            for (PurchaseMaterialHead materialHead : records) {
                PurchaseMaterialItem materialItem = (PurchaseMaterialItem)((Object)materialItemMap.get(materialHead.getId() + "&" + materialHead.getFactory()));
                if (materialItem == null) continue;
                materialHead.setDeliveryArrange(materialItem.getDeliveryArrange());
            }
        }
        return Result.ok((Object)materialHeadListObj);
    }

    @SrmValidated
    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:add"})
    @PermissionDataOpt(businessType="material", beanClass=PurchaseMaterialHeadService.class)
    public Result<?> add(@RequestBody PurchaseMaterialHeadVO purchaseMaterialHeadPage) {
        Assert.hasText((String)purchaseMaterialHeadPage.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)purchaseMaterialHeadPage.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseMaterialHeadVO purchaseMaterialHead = new PurchaseMaterialHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseMaterialHeadPage), (Object)((Object)purchaseMaterialHead));
        String elsAccount = this.getTenantId();
        purchaseMaterialHead.setElsAccount(elsAccount);
        purchaseMaterialHead.setBlocDel("0");
        this.purchaseMaterialHeadService.saveMain(purchaseMaterialHead, purchaseMaterialHeadPage.getPurchaseMaterialItemList(), purchaseMaterialHeadPage.getPurchaseMaterialMeterUnitList(), purchaseMaterialHeadPage.getAttachmentList());
        return Result.ok((Object)((Object)purchaseMaterialHead));
    }

    @SrmValidated
    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:edit"})
    @PermissionDataOpt(businessType="material", beanClass=PurchaseMaterialHeadService.class)
    public Result<?> edit(@RequestBody PurchaseMaterialHeadVO purchaseMaterialHeadPage) {
        PurchaseMaterialHead purchaseMaterialHead = new PurchaseMaterialHead();
        BeanUtils.copyProperties((Object)((Object)purchaseMaterialHeadPage), (Object)((Object)purchaseMaterialHead));
        purchaseMaterialHead.setFromEditPage(true);
        this.purchaseMaterialHeadService.updateMain(purchaseMaterialHead, purchaseMaterialHeadPage.getPurchaseMaterialItemList(), purchaseMaterialHeadPage.getPurchaseMaterialMeterUnitList(), purchaseMaterialHeadPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u6839\u636e\u5de5\u5382\u67e5\u8be2\u7269\u6599\u884c")
    @ApiOperation(value="\u6839\u636e\u5de5\u5382\u67e5\u8be2\u7269\u6599\u884c", notes="\u6839\u636e\u5de5\u5382\u67e5\u8be2\u7269\u6599\u884c")
    @GetMapping(value={"/queryMaterialItemByFactory"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:list"})
    public Result<?> queryMaterialItemByFactory(@RequestParam(name="materialNumber") String materialNumber, @RequestParam(name="factory") String factory) {
        PurchaseMaterialHead purchaseMaterialHead = new PurchaseMaterialHead();
        purchaseMaterialHead.setMaterialNumber(materialNumber);
        purchaseMaterialHead.setFactory(factory);
        PurchaseMaterialHead resultMaterialHead = this.purchaseMaterialHeadService.queryMaterialItemByFactory(purchaseMaterialHead);
        return Result.ok((Object)((Object)resultMaterialHead));
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:delete"})
    @PermissionDataOpt(businessType="material", beanClass=PurchaseMaterialHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseMaterialHeadService.delHead(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestBody List<String> ids) {
        this.purchaseMaterialHeadService.delBatchMain(ids);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:queryById"})
    @PermissionDataOpt(businessType="material", beanClass=PurchaseMaterialHeadService.class)
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadService.getById((Serializable)((Object)id)));
        PurchaseMaterialHeadVO purchaseMaterialHeadVO = new PurchaseMaterialHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseMaterialHead), (Object)((Object)purchaseMaterialHeadVO));
        List<PurchaseMaterialItem> purchaseMaterialItemList = this.purchaseMaterialItemService.selectByMainId(id);
        List<PurchaseMaterialUnit> purchaseMaterialMeterUnitList = this.purchaseMaterialUnitService.selectByMainId(id);
        purchaseMaterialHeadVO.setPurchaseMaterialItemList(purchaseMaterialItemList);
        purchaseMaterialHeadVO.setPurchaseMaterialMeterUnitList(purchaseMaterialMeterUnitList);
        List attachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseMaterialHeadVO.setAttachmentList(attachmentDTOS);
        return Result.ok((Object)((Object)purchaseMaterialHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u7269\u6599\u4e3b\u6570\u636e\u5934id\u67e5\u8be2\u7269\u6599\u4e3b\u6570\u636e\u884c", notes="\u901a\u8fc7\u7269\u6599\u4e3b\u6570\u636e\u5934id\u67e5\u8be2\u7269\u6599\u4e3b\u6570\u636e\u884c")
    @GetMapping(value={"/queryPurchaseMaterialItemByMainId"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:queryById"})
    public Result<?> queryPurchaseMaterialItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseMaterialItem> purchaseMaterialItemList = this.purchaseMaterialItemService.selectByMainId(id);
        return Result.ok(purchaseMaterialItemList);
    }

    @GetMapping(value={"/exportXls"})
    @PermissionDataView(businessType="material")
    @RequiresPermissions(value={"material#PurchaseMaterialHead:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseMaterialHeadExportServiceImpl.class);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u4eceERP\u83b7\u53d6\u6570\u636e")
    @ApiOperation(value="\u4eceERP\u83b7\u53d6\u6570\u636e", notes="\u4eceERP\u83b7\u53d6\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    public Result<?> getDataByErp(PurchaseMaterialHead materialHead) {
        this.purchaseMaterialHeadService.getDataByErp(materialHead);
        return Result.ok((Object)((Object)materialHead));
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u63a8\u9001\u7269\u6599")
    @ApiOperation(value="\u63a8\u9001\u7269\u6599", notes="\u63a8\u9001\u7269\u6599")
    @GetMapping(value={"/pushMaterialByManual"})
    @RequiresPermissions(value={"material#PurchaseMaterialHead:pushMaterialByManual"})
    public Result<?> pushMaterialByManual(@RequestParam(value="ids") String ids) {
        this.purchaseMaterialHeadService.pushMaterialByManual(ids);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u51bb\u7ed3\u9644\u4ef6")
    @ApiOperation(value="\u51bb\u7ed3\u9644\u4ef6", notes="\u51bb\u7ed3\u9644\u4ef6")
    @GetMapping(value={"/freezeAttachment"})
    public Result<?> freezeAttachment(@RequestParam(value="id") String id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().eq(BaseEntity::getId, (Object)id)).set(PurchaseAttachment::getFbk1, (Object)PurchaseAttachmentDisableEnum.FREEZE.getDesc());
        this.purchaseAttachmentService.update((Wrapper)updateWrapper);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u542f\u7528\u9644\u4ef6")
    @ApiOperation(value="\u542f\u7528\u9644\u4ef6", notes="\u542f\u7528\u9644\u4ef6")
    @GetMapping(value={"/enableAttachment"})
    public Result<?> enableAttachment(@RequestParam(value="id") String id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().eq(BaseEntity::getId, (Object)id)).set(PurchaseAttachment::getFbk1, (Object)PurchaseAttachmentDisableEnum.ENABLE.getDesc());
        this.purchaseAttachmentService.update((Wrapper)updateWrapper);
        return this.commonSuccessResult(4);
    }
}

