/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.extend.api.dto.SupplierOrgInfoDTO;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusErpEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierOrgInfoRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushPurchaseInformationRecordsToErpServiceImpl")
public class PushPurchaseInformationRecordsToErpServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushPurchaseInformationRecordsToErpServiceImpl.class);
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private PriceInvokeSupplierOrgInfoRpcService priceInvokeSupplierOrgInfoRpcService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        return super.invokeCheck(obj, custom);
    }

    public JSONObject before(JSONObject jsonObject, Object o) {
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)o);
        JSONObject body = new JSONObject();
        JSONObject model = new JSONObject();
        JSONArray fPriceListEntryArray = new JSONArray();
        SupplierOrgInfoDTO orgInfo = this.priceInvokeSupplierOrgInfoRpcService.getByAccount(records.getToElsAccount(), records.getElsAccount(), records.getPurchaseOrg());
        if (null == orgInfo) {
            throw new ELSBootException("\u672a\u627e\u5230\u4f9b\u5e94\u5546\u7ec4\u7ec7\u4fe1\u606f");
        }
        JSONObject fCreateOrgId = new JSONObject();
        fCreateOrgId.put("FNumber", (Object)records.getPurchaseOrg());
        model.put("FCreateOrgId", (Object)fCreateOrgId);
        model.put("FName", (Object)records.getInfoRecordNumber());
        model.put("FPriceObject", (Object)records.getPriceType());
        model.put("FPriceType", (Object)records.getRecordType());
        JSONObject currencyId = new JSONObject();
        currencyId.put("FNumber", (Object)records.getCurrencyCode());
        model.put("FCurrencyID", (Object)currencyId);
        JSONObject supplierId = new JSONObject();
        supplierId.put("FNumber", (Object)orgInfo.getSupplierCode());
        model.put("FSupplierID", (Object)supplierId);
        JSONObject fPricer = new JSONObject();
        model.put("FPricer", (Object)fPricer);
        model.put("FIsIncludedTax", (Object)"true");
        model.put("FDefPriceListId", (Object)"false");
        model.put("FDescription", (Object)records.getRemark());
        model.put("FIsPriceExcludeTax", (Object)"true");
        if (StringUtils.isNotBlank((CharSequence)records.getLadderPriceJson())) {
            JSONArray arrayList = JSONObject.parseArray((String)records.getLadderPriceJson());
            for (int i = 0; i < arrayList.size(); ++i) {
                JSONObject fPriceListEntry = this.initParams(records);
                JSONObject object = (JSONObject)Convert.convert(JSONObject.class, (Object)arrayList.get(i));
                String ladder = object.getString("ladder");
                this.initTy(fPriceListEntry, ladder);
                fPriceListEntry.put("FPrice", (Object)object.getString("netPrice"));
                String price = object.getString("price");
                fPriceListEntry.put("FTaxPrice", (Object)price);
                fPriceListEntry.put("FDownPrice", (Object)price);
                fPriceListEntry.put("FUpPrice", (Object)price);
                fPriceListEntryArray.add((Object)fPriceListEntry);
            }
        } else {
            JSONObject fPriceListEntry = this.initParams(records);
            fPriceListEntry.put("FFROMQTY", (Object)"0");
            fPriceListEntry.put("FToQty", (Object)"0");
            fPriceListEntry.put("FPrice", (Object)records.getNetPrice().stripTrailingZeros().toPlainString());
            String price = records.getPrice().stripTrailingZeros().toPlainString();
            fPriceListEntry.put("FTaxPrice", (Object)price);
            fPriceListEntry.put("FDownPrice", (Object)price);
            fPriceListEntry.put("FUpPrice", (Object)price);
            fPriceListEntryArray.add((Object)fPriceListEntry);
        }
        model.put("FPriceListEntry", (Object)fPriceListEntryArray);
        JSONArray needUpDateFields = new JSONArray();
        body.put("NeedUpDateFields", (Object)needUpDateFields);
        JSONArray needReturnFields = new JSONArray();
        body.put("NeedReturnFields", (Object)needReturnFields);
        body.put("IsDeleteEntry", (Object)"true");
        body.put("SubSystemId", (Object)"");
        body.put("IsVerifyBaseDataField", (Object)"false");
        body.put("IsEntryBatchFill", (Object)"true");
        body.put("ValidateFlag", (Object)"true");
        body.put("NumberSearch", (Object)"true");
        body.put("IsAutoAdjustField", (Object)"false");
        body.put("InterationFlags", (Object)"");
        body.put("IgnoreInterationFlag", (Object)"");
        body.put("IsControlPrecision", (Object)"false");
        body.put("Model", (Object)model);
        jsonObject.put("body", (Object)body);
        log.info("===jsonObject===\uff1a" + jsonObject);
        return jsonObject;
    }

    private void initTy(JSONObject fPriceListEntry, String ladder) {
        String[] s = ladder.split(" ");
        List<String> tyList = Arrays.asList(s);
        String fstartqty = tyList.get(0);
        String fendqty = tyList.get(tyList.size() - 1);
        if ("x".equals(fendqty)) {
            fendqty = "";
        }
        fendqty = StringUtils.isNotBlank((CharSequence)fendqty) ? String.valueOf(Integer.valueOf(fendqty) - 1) : "";
        fPriceListEntry.put("FFROMQTY", (Object)fstartqty);
        fPriceListEntry.put("FToQty", (Object)fendqty);
    }

    private JSONObject initParams(PurchaseInformationRecords records) {
        JSONObject fPriceListEntry = new JSONObject();
        JSONObject materialId = new JSONObject();
        materialId.put("FNumber", (Object)records.getMaterialNumber());
        fPriceListEntry.put("FMaterialId", (Object)materialId);
        JSONObject materialGroupId = new JSONObject();
        materialGroupId.put("FNUMBER", (Object)"");
        fPriceListEntry.put("FMaterialGroupId", (Object)materialGroupId);
        JSONObject auxPropId = new JSONObject();
        fPriceListEntry.put("FAuxPropId", (Object)auxPropId);
        JSONObject materialTypeId = new JSONObject();
        materialTypeId.put("FNumber", (Object)"");
        fPriceListEntry.put("FMaterialTypeId", (Object)materialTypeId);
        JSONObject unitId = new JSONObject();
        unitId.put("FNumber", (Object)records.getPurchaseUnit());
        fPriceListEntry.put("FUnitID", (Object)unitId);
        fPriceListEntry.put("FTaxRate", (Object)records.getTaxRate());
        fPriceListEntry.put("FPriceCoefficient", (Object)"1");
        fPriceListEntry.put("FEntryEffectiveDate", (Object)(records.getEffectiveDate() == null ? DateUtil.format((Date)records.getCreateTime(), (String)"yyyy-MM-dd") : DateUtil.format((Date)records.getEffectiveDate(), (String)"yyyy-MM-dd")));
        fPriceListEntry.put("FEntryExpiryDate", (Object)(records.getExpiryDate() == null ? "2999-12-31" : DateUtil.format((Date)records.getExpiryDate(), (String)"yyyy-MM-dd")));
        fPriceListEntry.put("FNote", (Object)"");
        fPriceListEntry.put("FPRICEFROM", (Object)records.getSourceType());
        fPriceListEntry.put("FFROMBILLNO", (Object)records.getSourceNumber());
        fPriceListEntry.put("FSrcBillNo", (Object)records.getSourceNumber());
        return fPriceListEntry;
    }

    public JSONObject after(JSONObject jsonObject, JSONObject jsonObject1, Object o) {
        JSONObject responseStatus;
        if (200 == jsonObject.getIntValue("code")) {
            responseStatus = jsonObject.getJSONObject("result").getJSONObject("Result").getJSONObject("ResponseStatus");
            String isSuccess = responseStatus.getString("IsSuccess");
            if (!"true".equals(isSuccess)) {
                String message = responseStatus.getJSONArray("Errors").getJSONObject(0).getString("Message");
                throw new ELSBootException("SRM\u63a8\u9001\u4ef7\u683c\u4e3b\u6570\u636e\u81f3\u91d1\u8776\u7cfb\u7edf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a[" + message + "]");
            }
        } else {
            throw new ELSBootException("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5f02\u5e38\uff0c\u62a5\u9519\u8be6\u60c5\u4e3a\uff1a" + jsonObject.getString("message"));
        }
        String id = responseStatus.getJSONArray("SuccessEntitys").getJSONObject(0).getString("Id");
        String number = responseStatus.getJSONArray("SuccessEntitys").getJSONObject(0).getString("Number");
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)o);
        records.setInterfaceMsg(number);
        records.setReturnState("1");
        records.setFbk1(id);
        records.setFbk2(PriceStatusErpEnum.NEW.getValue());
        this.purchaseInformationRecordsService.updateById((Object)records);
        return jsonObject;
    }
}

