/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseInformationRecordsExcelHandler")
public class PurchaseInformationRecordsExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List headList;
        Map collect;
        Object headList2;
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        com.els.common.util.Assert.isNotNull((Object)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u4ef7\u683c\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f"));
        ArrayList<PurchaseInformationRecords> entityList = new ArrayList<PurchaseInformationRecords>();
        ArrayList<String> code = new ArrayList<String>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        for (Map data : dataList) {
            String materialNumber = (String)data.get("materialNumber");
            String toElsAccount = (String)data.get("toElsAccount");
            if (CharSequenceUtil.isNotEmpty((CharSequence)materialNumber) && !code.contains(materialNumber)) {
                code.add(materialNumber);
            }
            if (!CharSequenceUtil.isNotEmpty((CharSequence)toElsAccount) || toElsAccountList.contains(toElsAccount)) continue;
            toElsAccountList.add(toElsAccount);
        }
        Map<Object, Object> collectMaterialMap = new HashMap();
        if (CollUtil.isNotEmpty(code)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialHead::getMaterialNumber, PurchaseMaterialHead::getMaterialName, PurchaseMaterialHead::getMaterialDesc, PurchaseMaterialHead::getMaterialGroup, BaseEntity::getId, PurchaseMaterialHead::getBaseUnit});
            wrapper.in(PurchaseMaterialHead::getMaterialNumber, code);
            headList2 = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
            collectMaterialMap = headList2.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v1));
        }
        Map<Object, Object> collectMasterMap = new HashMap();
        if (CollUtil.isNotEmpty(toElsAccountList)) {
            headList2 = this.priceInvokeSupplierRpcService.listByElsAccount(toElsAccountList);
            collectMasterMap = headList2.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v1));
        }
        for (Map data : dataList) {
            PurchaseInformationRecords entity = (PurchaseInformationRecords)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseInformationRecords.class));
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setElsAccount(TenantContext.getTenant());
            entity.setSourceType(PriceSourceTypeEnum.SRM.getValue());
            entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            entity.setTaxRate(null);
            entity.setTaxCode(entity.getTaxCode());
            if (null != entity.getExpiryDate() && null != entity.getEffectiveDate() && entity.getExpiryDate().before(entity.getEffectiveDate())) {
                String msg = I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            PurchaseMaterialHead materialHead = (PurchaseMaterialHead)((Object)collectMaterialMap.get(entity.getMaterialNumber()));
            if (CharSequenceUtil.isNotEmpty((CharSequence)entity.getMaterialNumber()) && null == materialHead) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoxMK_cdf9d7c2", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728") + entity.getMaterialNumber();
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (CharSequenceUtil.isBlank((CharSequence)entity.getMaterialNumber())) {
                entity.setMaterialId(null);
                entity.setMaterialDesc(null);
                entity.setMaterialName(null);
                entity.setMaterialGroup(null);
            }
            if (null != materialHead) {
                entity.setMaterialId(materialHead.getId());
                entity.setMaterialDesc(materialHead.getMaterialDesc());
                entity.setMaterialName(materialHead.getMaterialName());
                entity.setMaterialGroup(materialHead.getMaterialGroup());
            }
            SupplierMasterDataDTO masterDataDTO = (SupplierMasterDataDTO)collectMasterMap.get(entity.getToElsAccount());
            if (CharSequenceUtil.isBlank((CharSequence)entity.getToElsAccount())) {
                entity.setToElsAccount(null);
                entity.setSupplierName(null);
                entity.setSupplierCode(null);
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)entity.getToElsAccount()) && null == masterDataDTO) {
                String msg = I18nUtil.translate((String)"i18n_alert_RdXWWWeyWWWWWWxMKWVnIWFW_77bcc1ac", (String)("\u4f9b\u5e94\u5546ELS\u8d26\u53f7\uff1a" + entity.getToElsAccount() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01"), (String[])new String[]{entity.getToElsAccount()});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (null != masterDataDTO) {
                entity.setSupplierCode(masterDataDTO.getSupplierCode());
                entity.setSupplierName(masterDataDTO.getSupplierName());
            }
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPriceNumber", entityList.get(0), size);
        Assert.notEmpty((Collection)nextCodes, (String)"\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e\u7f16\u7801\u751f\u6210\u5f02\u5e38");
        int codeIndex = 0;
        for (PurchaseInformationRecords e : entityList) {
            e.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
        }
        List taxCode = entityList.stream().map(PurchaseInformationRecords::getTaxCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(taxCode) && CollUtil.isNotEmpty(collect = (headList = this.invokeBaseRpcService.getElsTaxByCode(taxCode)).stream().collect(Collectors.toMap(ElsTaxDTO::getTaxCode, Function.identity(), (v1, v2) -> v1)))) {
            for (PurchaseInformationRecords r : entityList) {
                ElsTaxDTO head = (ElsTaxDTO)collect.get(r.getTaxCode());
                if (null != head) {
                    r.setTaxCode(head.getTaxCode());
                    r.setTaxRate(head.getTaxRate().toString());
                    continue;
                }
                r.setTaxCode(null);
                r.setTaxRate(null);
            }
        }
        for (PurchaseInformationRecords entity : entityList) {
            this.purchaseInformationRecordsService.calculatePrice(entity);
            entity.setQuoteDate(entity.getQuoteDate() == null ? new Date() : entity.getQuoteDate());
            entity.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
            entity.setUpdateBy(null);
            entity.setUpdateTime(null);
            entity.setId(null);
        }
        this.purchaseInformationRecordsService.saveBatch(entityList, 2000);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

